/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.dartsclone.Pair;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLSentence;
import com.hankcs.hanlp.corpus.io.ByteArrayStream;
import com.hankcs.hanlp.dependency.MinimumSpanningTreeParser;
import com.hankcs.hanlp.dependency.common.Edge;
import com.hankcs.hanlp.dependency.common.Node;
import com.hankcs.hanlp.model.maxent.MaxEntModel;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.utility.Predefine;
import java.util.LinkedList;
import java.util.List;

public class MaxEntDependencyParser
extends MinimumSpanningTreeParser {
    static final MaxEntDependencyParser INSTANCE = new MaxEntDependencyParser();
    static MaxEntModel model;

    static {
        long start = System.currentTimeMillis();
        ByteArrayStream byteArray = ByteArrayStream.createByteArrayStream(String.valueOf(HanLP.Config.MaxEntModelPath) + ".bin");
        model = byteArray != null ? MaxEntModel.create(byteArray) : MaxEntModel.create(HanLP.Config.MaxEntModelPath);
        String result = model == null ? "\u5931\u8d25" : "\u6210\u529f";
        Predefine.logger.info("\u6700\u5927\u71b5\u4f9d\u5b58\u53e5\u6cd5\u6a21\u578b\u8f7d\u5165" + result + "\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + " ms");
    }

    public static CoNLLSentence compute(List<Term> termList) {
        return INSTANCE.parse(termList);
    }

    public static CoNLLSentence compute(String sentence) {
        return INSTANCE.parse(sentence);
    }

    @Override
    protected Edge makeEdge(Node[] nodeArray, int from, int to) {
        Node w;
        LinkedList<String> context = new LinkedList<String>();
        int index = from;
        int i = index - 2;
        while (i < index + 2 + 1) {
            w = i >= 0 && i < nodeArray.length ? nodeArray[i] : Node.NULL;
            context.add(String.valueOf(w.compiledWord) + "i" + (i - index));
            context.add(String.valueOf(w.label) + "i" + (i - index));
            ++i;
        }
        index = to;
        i = index - 2;
        while (i < index + 2 + 1) {
            w = i >= 0 && i < nodeArray.length ? nodeArray[i] : Node.NULL;
            context.add(String.valueOf(w.compiledWord) + "j" + (i - index));
            context.add(String.valueOf(w.label) + "j" + (i - index));
            ++i;
        }
        context.add(String.valueOf(nodeArray[from].compiledWord) + '\u2192' + nodeArray[to].compiledWord);
        context.add(String.valueOf(nodeArray[from].label) + '\u2192' + nodeArray[to].label);
        context.add(String.valueOf(nodeArray[from].compiledWord) + '\u2192' + nodeArray[to].compiledWord + (from - to));
        context.add(String.valueOf(nodeArray[from].label) + '\u2192' + nodeArray[to].label + (from - to));
        Node wordBeforeI = from - 1 >= 0 ? nodeArray[from - 1] : Node.NULL;
        Node wordBeforeJ = to - 1 >= 0 ? nodeArray[to - 1] : Node.NULL;
        context.add(String.valueOf(wordBeforeI.compiledWord) + '@' + nodeArray[from].compiledWord + '\u2192' + nodeArray[to].compiledWord);
        context.add(String.valueOf(nodeArray[from].compiledWord) + '\u2192' + wordBeforeJ.compiledWord + '@' + nodeArray[to].compiledWord);
        context.add(String.valueOf(wordBeforeI.label) + '@' + nodeArray[from].label + '\u2192' + nodeArray[to].label);
        context.add(String.valueOf(nodeArray[from].label) + '\u2192' + wordBeforeJ.label + '@' + nodeArray[to].label);
        List<Pair<String, Double>> pairList = model.predict(context.toArray(new String[0]));
        Pair<String, Double> maxPair = new Pair<String, Double>("null", -1.0);
        for (Pair<String, Double> pair : pairList) {
            if (!(pair.getValue() > maxPair.getValue()) || "null".equals(pair.getKey())) continue;
            maxPair = pair;
        }
        return new Edge(from, to, maxPair.getKey(), (float)(-Math.log(maxPair.getValue())));
    }
}

