/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dictionary.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class SimpleItem {
    public Map<String, Integer> labelMap = new TreeMap<String, Integer>();

    public void addLabel(String label) {
        Integer frequency = this.labelMap.get(label);
        frequency = frequency == null ? Integer.valueOf(1) : Integer.valueOf(frequency + 1);
        this.labelMap.put(label, frequency);
    }

    public void addLabel(String label, Integer frequency) {
        Integer innerFrequency = this.labelMap.get(label);
        innerFrequency = innerFrequency == null ? frequency : Integer.valueOf(innerFrequency + frequency);
        this.labelMap.put(label, innerFrequency);
    }

    public boolean containsLabel(String label) {
        return this.labelMap.containsKey(label);
    }

    public int getFrequency(String label) {
        Integer frequency = this.labelMap.get(label);
        if (frequency == null) {
            return 0;
        }
        return frequency;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Map.Entry<String, Integer>> entries = new ArrayList<Map.Entry<String, Integer>>(this.labelMap.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return -o1.getValue().compareTo(o2.getValue());
            }
        });
        for (Map.Entry<String, Integer> entry : entries) {
            sb.append(entry.getKey());
            sb.append(' ');
            sb.append(entry.getValue());
            sb.append(' ');
        }
        return sb.toString();
    }

    public static SimpleItem create(String param) {
        if (param == null) {
            return null;
        }
        String[] array = param.split(" ");
        return SimpleItem.create(array);
    }

    public static SimpleItem create(String[] param) {
        if (param.length % 2 == 1) {
            return null;
        }
        SimpleItem item = new SimpleItem();
        int natureCount = param.length / 2;
        int i = 0;
        while (i < natureCount) {
            item.labelMap.put(param[2 * i], Integer.parseInt(param[1 + 2 * i]));
            ++i;
        }
        return item;
    }

    public void combine(SimpleItem other) {
        for (Map.Entry<String, Integer> entry : other.labelMap.entrySet()) {
            this.addLabel(entry.getKey(), entry.getValue());
        }
    }

    public int getTotalFrequency() {
        int frequency = 0;
        for (Integer f : this.labelMap.values()) {
            frequency += f.intValue();
        }
        return frequency;
    }

    public String getMostLikelyLabel() {
        return this.labelMap.entrySet().iterator().next().getKey();
    }
}

