/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dependency.model;

import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLLoader;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLSentence;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLWord;
import com.hankcs.hanlp.corpus.dictionary.DictionaryMaker;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.corpus.io.IOUtil;
import java.util.TreeSet;

public class WordNatureWeightModelMaker {
    public static boolean makeModel(String corpusLoadPath, String modelSavePath) {
        CoNLLWord word;
        int n;
        int n2;
        CoNLLWord[] coNLLWordArray;
        TreeSet<String> posSet = new TreeSet<String>();
        DictionaryMaker dictionaryMaker = new DictionaryMaker();
        for (CoNLLSentence sentence : CoNLLLoader.loadSentenceList(corpusLoadPath)) {
            coNLLWordArray = sentence.word;
            n2 = sentence.word.length;
            n = 0;
            while (n < n2) {
                word = coNLLWordArray[n];
                WordNatureWeightModelMaker.addPair(word.NAME, word.HEAD.NAME, word.DEPREL, dictionaryMaker);
                WordNatureWeightModelMaker.addPair(word.NAME, WordNatureWeightModelMaker.wrapTag(word.HEAD.POSTAG), word.DEPREL, dictionaryMaker);
                WordNatureWeightModelMaker.addPair(WordNatureWeightModelMaker.wrapTag(word.POSTAG), word.HEAD.NAME, word.DEPREL, dictionaryMaker);
                WordNatureWeightModelMaker.addPair(WordNatureWeightModelMaker.wrapTag(word.POSTAG), WordNatureWeightModelMaker.wrapTag(word.HEAD.POSTAG), word.DEPREL, dictionaryMaker);
                posSet.add(word.POSTAG);
                ++n;
            }
        }
        for (CoNLLSentence sentence : CoNLLLoader.loadSentenceList(corpusLoadPath)) {
            coNLLWordArray = sentence.word;
            n2 = sentence.word.length;
            n = 0;
            while (n < n2) {
                word = coNLLWordArray[n];
                WordNatureWeightModelMaker.addPair(word.NAME, word.HEAD.NAME, word.DEPREL, dictionaryMaker);
                WordNatureWeightModelMaker.addPair(word.NAME, WordNatureWeightModelMaker.wrapTag(word.HEAD.POSTAG), word.DEPREL, dictionaryMaker);
                WordNatureWeightModelMaker.addPair(WordNatureWeightModelMaker.wrapTag(word.POSTAG), word.HEAD.NAME, word.DEPREL, dictionaryMaker);
                WordNatureWeightModelMaker.addPair(WordNatureWeightModelMaker.wrapTag(word.POSTAG), WordNatureWeightModelMaker.wrapTag(word.HEAD.POSTAG), word.DEPREL, dictionaryMaker);
                posSet.add(word.POSTAG);
                ++n;
            }
        }
        StringBuilder sb = new StringBuilder();
        for (String pos : posSet) {
            sb.append("case \"" + pos + "\":\n");
        }
        IOUtil.saveTxt("data/model/dependency/pos-thu.txt", sb.toString());
        return dictionaryMaker.saveTxtTo(modelSavePath);
    }

    private static void addPair(String from, String to, String label, DictionaryMaker dictionaryMaker) {
        dictionaryMaker.add(new Word(String.valueOf(from) + "@" + to, label));
        dictionaryMaker.add(new Word(String.valueOf(from) + "@", "\u9891\u6b21"));
    }

    public static String wrapTag(String tag) {
        return "<" + tag + ">";
    }

    public static void main(String[] args) {
        WordNatureWeightModelMaker.makeModel("D:\\Doc\\\u8bed\u6599\u5e93\\\u4f9d\u5b58\u5206\u6790\u8bad\u7ec3\u6570\u636e\\THU\\train.conll.fixed.txt", "data/model/dependency/WordNature.txt");
    }
}

