/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dependency.CoNll;

import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLSentence;
import java.text.NumberFormat;

public class Evaluator {
    float U;
    float L;
    float D;
    float A;
    int sentenceCount;
    long start = System.currentTimeMillis();

    public void e(CoNLLSentence right, CoNLLSentence test) {
        ++this.sentenceCount;
        this.A += (float)right.word.length;
        int i = 0;
        while (i < test.word.length) {
            if (test.word[i].HEAD.ID == right.word[i].HEAD.ID) {
                this.U += 1.0f;
                if (right.word[i].DEPREL.equals(test.word[i].DEPREL)) {
                    this.L += 1.0f;
                    if (test.word[i].HEAD.ID != 0) {
                        this.D += 1.0f;
                    }
                }
            }
            ++i;
        }
    }

    public float getUA() {
        return this.U / this.A;
    }

    public float getLA() {
        return this.L / this.A;
    }

    public float getDA() {
        return this.D / (this.A - (float)this.sentenceCount);
    }

    public String toString() {
        NumberFormat percentFormat = NumberFormat.getPercentInstance();
        percentFormat.setMinimumFractionDigits(2);
        StringBuilder sb = new StringBuilder();
        sb.append("UA: ");
        sb.append(percentFormat.format(this.getUA()));
        sb.append('\t');
        sb.append("LA: ");
        sb.append(percentFormat.format(this.getLA()));
        sb.append('\t');
        sb.append("DA: ");
        sb.append(percentFormat.format(this.getDA()));
        sb.append('\t');
        sb.append("sentences: ");
        sb.append(this.sentenceCount);
        sb.append('\t');
        sb.append("speed: ");
        sb.append((float)this.sentenceCount / (float)(System.currentTimeMillis() - this.start) * 1000.0f);
        sb.append(" sent/s");
        return sb.toString();
    }
}

