/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.algoritm;

import com.hankcs.hanlp.algoritm.EditDistance;
import com.hankcs.hanlp.corpus.synonym.Synonym;
import com.hankcs.hanlp.dictionary.common.CommonSynonymDictionary;
import java.util.List;

public class VectorDistance {
    public static long compute(long[] arrayA, long[] arrayB) {
        int m = arrayA.length;
        int n = arrayB.length;
        if (m == 0 || n == 0) {
            return 1L;
        }
        long total = 0L;
        long[] lArray = arrayA;
        int n2 = arrayA.length;
        int n3 = 0;
        while (n3 < n2) {
            long va = lArray[n3];
            long min_distance = Long.MAX_VALUE;
            long[] lArray2 = arrayB;
            int n4 = arrayB.length;
            int n5 = 0;
            while (n5 < n4) {
                long vb = lArray2[n5];
                min_distance = Math.min(min_distance, Math.abs(va - vb));
                ++n5;
            }
            total += min_distance;
            ++n3;
        }
        return total / (long)m;
    }

    public static double compute(List<CommonSynonymDictionary.SynonymItem> synonymItemListA, List<CommonSynonymDictionary.SynonymItem> synonymItemListB) {
        double total = 0.0;
        for (CommonSynonymDictionary.SynonymItem itemA : synonymItemListA) {
            long min_distance = Long.MAX_VALUE;
            for (CommonSynonymDictionary.SynonymItem itemB : synonymItemListB) {
                long distance = itemA.type != Synonym.Type.UNDEFINED && itemB.type != Synonym.Type.UNDEFINED ? Math.abs(itemA.entry.id - itemB.entry.id) : (long)(EditDistance.ed(itemA.entry.realWord, itemB.entry.realWord) * 1000000);
                min_distance = Math.min(min_distance, distance);
            }
            total += (double)min_distance;
        }
        return total;
    }
}

