package com.zzsn.excelexportservice.exportStrategys;


import com.fasterxml.jackson.databind.ObjectMapper;
import com.zzsn.excelexportservice.dto.*;
import com.zzsn.excelexportservice.feign.EnterpriseFeign;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: lxj
 * @Date: 2025/9/26 14:52
 */
@Component
public class EnterpriseStrategy implements ExportStrategy {

    @Autowired
    private EnterpriseFeign enterpriseFeign;

    private final Map<String, TriFunction<HttpServletRequest, Map<String, Object>, ExportReq, ExportDataResponse<?>>> pathMapping = new HashMap<>();
    private final ObjectMapper mapper = new ObjectMapper();

    @PostConstruct
    public void init() {
        // 映射接口
        register("/company/enterprise/detail/indexQuery/export/excel",
                (request, queryParams, exportReq) -> enterpriseFeign.enterpriseIndexQueryExport(
                        RequestParamHelper.getStringParam(queryParams, "socialCreditCode"),
                        RequestParamHelper.getIntegerParam(queryParams, "indexType"),
                        RequestParamHelper.getStringParam(queryParams, "indexNames")
                ));

        register("/company/enterpriseData/getOnListRecord/export/excel",
                (request, queryParams, exportReq) -> enterpriseFeign.getOnListRecordExport(
                        RequestParamHelper.getStringParam(queryParams, "socialCreditCodes"),
                        RequestParamHelper.getStringParam(queryParams, "yearList"),
                        RequestParamHelper.getStringParam(queryParams, "lists"),
                        RequestParamHelper.getStringParam(queryParams, "type")
                ));

        register("/company/finance_new/indexCompare/export/excel",
                (request, queryParams, exportReq) -> enterpriseFeign.indexCompareExport(
                        RequestParamHelper.getListParam(queryParams, "socialCreditCode"),
                        RequestParamHelper.getListParam(queryParams, "year"),
                        RequestParamHelper.getIntegerParam(queryParams, "quarter"),
                        RequestParamHelper.getStringParam(queryParams, "indexCode")
                ));

        register("/company/enterprise/rankList/getWorldTopAnalysis/export/excel",
                (request, queryParams, exportReq) -> enterpriseFeign.getWorldTopAnalysis(
                        mapper.convertValue(queryParams, WorldTopAnalysis.class)
                ));

        register("/company/finance_new/indexCompareByIndustry/export/excel",
                (request, queryParams, exportReq) -> enterpriseFeign.indexCompareByIndustryExport(
                        mapper.convertValue(queryParams, WorldTopAnalysis.class),
                        RequestParamHelper.getListParam(queryParams, "socialCreditCode"),
                        RequestParamHelper.getListParam(queryParams, "year"),
                        RequestParamHelper.getIntegerParam(queryParams, "quarter"),
                        RequestParamHelper.getStringParam(queryParams, "industries"),
                        RequestParamHelper.getStringParam(queryParams, "indexCode")
                ));

        register("/company/finance_new/coreIndexCompareByIndustry/export/excel",
                (request, queryParams, exportReq) -> enterpriseFeign.coreIndexCompareByIndustryExport(
                        RequestParamHelper.getListParam(queryParams, "socialCreditCode"),
                        RequestParamHelper.getListParam(queryParams, "year"),
                        RequestParamHelper.getStringParam(queryParams, "industries"),
                        RequestParamHelper.getStringParam(queryParams, "indexName"),
                        RequestParamHelper.getStringParam(queryParams, "type")
                ));

        register("/company/enterprise/rankList/getEnterpriseBenchmarking/export/excel",
                (request, queryParams, exportReq) -> enterpriseFeign.getEnterpriseBenchmarkingExport(
                        mapper.convertValue(queryParams, WorldTopAnalysis.class),
                        RequestParamHelper.getStringParam(queryParams, "ids"),
                        RequestParamHelper.getStringParam(queryParams, "years"),
                        RequestParamHelper.getStringParam(queryParams, "industrys"),
                        RequestParamHelper.getStringParam(queryParams, "indexCode")
                ));

        register("/company/enterprise/rankList/getTransnationalCompany/export/excel",
                (request, queryParams, exportReq) -> enterpriseFeign.getTransnationalCompanyExport(
                        mapper.convertValue(queryParams, WorldTopAnalysis.class),
                        RequestParamHelper.getStringParam(queryParams, "ids"),
                        RequestParamHelper.getStringParam(queryParams, "years"),
                        RequestParamHelper.getStringParam(queryParams, "industrys"),
                        RequestParamHelper.getStringParam(queryParams, "indexCode")
                ));

        register("/company/aei/pageList/export/excel",
                (request, queryParams, exportReq) -> enterpriseFeign.getPageAndTotalExport(
                        RequestParamHelper.getIntegerParam(queryParams, "pageSize"),
                        RequestParamHelper.getIntegerParam(queryParams, "currentPage"),
                        mapper.convertValue(queryParams, AeiModuleVo.class)
                ));

        register("/company/finance_new/coreIndexCompare/export/excel",
                (request, queryParams, exportReq) -> enterpriseFeign.coreIndexCompareExport(
                        RequestParamHelper.getListParam(queryParams, "socialCreditCode"),
                        RequestParamHelper.getListParam(queryParams, "year"),
                        RequestParamHelper.getIntegerParam(queryParams, "quarter"),
                        RequestParamHelper.getStringParam(queryParams, "indexName")
                ));
    }

    private void register(String path,
                          TriFunction<HttpServletRequest, Map<String, Object>, ExportReq, ExportDataResponse<?>> func) {
        pathMapping.put(path, (request, queryParams, exportReq) -> {
            try {
                return func.apply(request, queryParams, exportReq);
            } catch (Exception e) {
                // 返回统一业务错误码，前端可以显示提示
                return new ExportDataResponse<>(2, "调用企业接口失败：" + e.getMessage(),
                        Collections.emptyList(), Collections.emptyList());
            }
        });
    }

    @Override
    public String getServiceName() {
        return "enterprise-service";
    }

    @Override
    public String getApiPath() {
        return null; // 所有接口由本策略处理
    }

    @Override
    public ExportDataResponse<?> execute(HttpServletRequest request, Map<String, Object> queryParams, ExportReq exportReq) {
        TriFunction<HttpServletRequest, Map<String, Object>, ExportReq, ExportDataResponse<?>> func =
                pathMapping.get(exportReq.getApiPath());
        if (func == null) {
            return new ExportDataResponse<>(404, "未找到匹配的接口: " + exportReq.getApiPath(),
                    Collections.emptyList(), Collections.emptyList());
        }
        return func.apply(request, queryParams, exportReq);
    }
}
