package com.zzsn.excelexportservice.exportStrategys;

import com.alibaba.fastjson2.JSONObject;
import com.zzsn.excelexportservice.dto.ExportDataResponse;
import com.zzsn.excelexportservice.dto.ExportReq;
import com.zzsn.excelexportservice.dto.RequestParamHelper;
import com.zzsn.excelexportservice.feign.ThinkTanKFeign;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author: lxj
 * @Date: 2025/10/10 15:21
 */
@Component
public class ThinkTanKStrategy implements ExportStrategy {
    @Autowired
    private ThinkTanKFeign thinkTanKFeign;

    private final Map<String, TriFunction<HttpServletRequest, Map<String, Object>, ExportReq, ExportDataResponse<?>>> pathMapping = new HashMap<>();

    @PostConstruct
    public void init() {
        // 通用接口导出
        register("/thinkTanK/api/basicinfo/queryStatisticalAnalysis/export/excel",
                (request, queryParams, exportReq) -> thinkTanKFeign.queryStatisticalAnalysisExport(
                        RequestParamHelper.getStringParam(queryParams, "type")));

    }

    private void register(String path,
                          TriFunction<HttpServletRequest, Map<String, Object>, ExportReq, ExportDataResponse<?>> func) {
        pathMapping.put(path, (request, queryParams, exportReq) -> {
            try {
                return func.apply(request, queryParams, exportReq);
            } catch (Exception e) {
                // Feign 调用异常或其他不可预期异常统一处理
                return new ExportDataResponse<>(2, "调用 think-tank 接口失败：" + e.getMessage(),
                        Collections.emptyList(), Collections.emptyList());
            }
        });
    }

    @Override
    public String getServiceName() {
        return "think-tank";
    }

    @Override
    public String getApiPath() {
        return null; // 所有接口由本策略处理
    }

    @Override
    public ExportDataResponse<?> execute(HttpServletRequest request, Map<String, Object> queryParams, ExportReq exportReq) {
        TriFunction<HttpServletRequest, Map<String, Object>, ExportReq, ExportDataResponse<?>> func =
                pathMapping.get(exportReq.getApiPath());
        if (func == null) {
            return new ExportDataResponse<>(404, "未找到匹配的接口: " + exportReq.getApiPath(),
                    Collections.emptyList(), Collections.emptyList());
        }
        return func.apply(request, queryParams, exportReq);
    }
}
