package com.zzsn.excelexportservice.exportStrategys;


import com.zzsn.excelexportservice.dto.ExportDataResponse;
import com.zzsn.excelexportservice.dto.ExportReq;
import jakarta.servlet.http.HttpServletRequest;

import java.util.Map;

/**
 * @Author: lxj
 * @Date: 2025/9/25 16:45
 */
public interface  ExportStrategy {
    /**
     * 当前策略支持的 serviceName
     */
    String getServiceName();

    /**
     * 当前策略支持的 apiPath
     * - 如果返回 null，表示该 serviceName 下所有 apiPath 都交给它处理
     * - 如果返回具体字符串，就只处理对应的 apiPath
     */
    default String getApiPath() {
        return null;
    }

    /**
     * 执行导出逻辑
     */
    ExportDataResponse<?> execute(HttpServletRequest request, Map<String, Object> queryParams, ExportReq exportReq);
}
