package com.zzsn.excelexportservice.exportStrategys;

import com.alibaba.fastjson2.JSONObject;

import com.zzsn.excelexportservice.dto.ExportDataResponse;
import com.zzsn.excelexportservice.dto.ExportReq;
import com.zzsn.excelexportservice.dto.RequestParamHelper;
import com.zzsn.excelexportservice.service.CmsSearch;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @Author: lxj
 * @Date: 2025/9/25 16:51
 */
@Component
public class CmsSubjectRelationInfoStrategy implements ExportStrategy {

    @Resource
    private CmsSearch cmsSearch;

    private final Map<String, TriFunction<HttpServletRequest, Map<String, Object>, ExportReq, ExportDataResponse<?>>> pathMapping = new HashMap<>();

    @PostConstruct
    public void init() {
        register("/cms/cmsSubject/getSubjectRelationInfo/export/excel",
                (request, queryParams, exportReq) -> {
                    String accesstoken = request.getHeader("Accesstoken");
                    String s = cmsSearch.getLdjh(
                            accesstoken,
                            RequestParamHelper.getParam(queryParams, "operationType"),
                            RequestParamHelper.getParam(queryParams, "leaderId"),
                            RequestParamHelper.getParam(queryParams, "subjectId"),
                            RequestParamHelper.getParam(queryParams, "pStartTime"),
                            RequestParamHelper.getParam(queryParams, "pEndTime"),
                            RequestParamHelper.getParam(queryParams, "limitNumber")
                    );

                    JSONObject jsonObject = JSONObject.parseObject(s);
                    if (jsonObject.getInteger("code") != 0) {
                        return new ExportDataResponse<>(jsonObject.getInteger("code"), jsonObject.getString("message"),
                                Collections.emptyList(), Collections.emptyList());
                    }

                    JSONObject model = jsonObject.getJSONObject("data").getJSONObject("model");
                    if (model == null || model.getJSONArray("rows") == null) {
                        return new ExportDataResponse<>(1, "接口返回数据为空", Collections.emptyList(), Collections.emptyList());
                    }

                    List<Object> rows = model.getJSONArray("rows");
                    List<ExportDataResponse.Header> headers = new ArrayList<>();
                    headers.add(new ExportDataResponse.Header("name", "热词"));
                    headers.add(new ExportDataResponse.Header("value", "词频"));

                    return new ExportDataResponse<>(0, "success", headers, rows);
                });

        // 以后可以继续 put 其他 CMS 导出接口
    }

    private void register(String path,
                          TriFunction<HttpServletRequest, Map<String, Object>, ExportReq, ExportDataResponse<?>> func) {
        pathMapping.put(path, (request, queryParams, exportReq) -> {
            try {
                return func.apply(request, queryParams, exportReq);
            } catch (com.dtflys.forest.exceptions.ForestRuntimeException fre) {
                // Forest 调用异常，比如 token 过期或连接失败
                return new ExportDataResponse<>(2, "调用 CMS 接口失败：" + fre.getMessage(),
                        Collections.emptyList(), Collections.emptyList());
            } catch (Exception e) {
                // 其他不可预期的异常
                return new ExportDataResponse<>(3, "导出内部错误：" + e.getMessage(),
                        Collections.emptyList(), Collections.emptyList());
            }
        });
    }

    @Override
    public String getServiceName() {
        return "cms-server";
    }

    @Override
    public String getApiPath() {
        return null; // 所有接口由本策略处理
    }

    @Override
    public ExportDataResponse<?> execute(HttpServletRequest request, Map<String, Object> queryParams, ExportReq exportReq) {
        TriFunction<HttpServletRequest, Map<String, Object>, ExportReq, ExportDataResponse<?>> func =
                pathMapping.get(exportReq.getApiPath());
        if (func == null) {
            return new ExportDataResponse<>(404, "未找到匹配的接口: " + exportReq.getApiPath(),
                    Collections.emptyList(), Collections.emptyList());
        }
        return func.apply(request, queryParams, exportReq);
    }
}

