package com.zzsn.excelexportservice.exportStrategys;


import com.fasterxml.jackson.databind.ObjectMapper;
import com.zzsn.excelexportservice.dto.ColumnParamSeniorVo;
import com.zzsn.excelexportservice.dto.ExportDataResponse;
import com.zzsn.excelexportservice.dto.ExportReq;
import com.zzsn.excelexportservice.dto.RequestParamHelper;
import com.zzsn.excelexportservice.feign.CharacterFeign;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author: lxj
 * @Date: 2025/9/26 11:53
 */
@Component
public class CharacterStrategy implements ExportStrategy {

    @Autowired
    private CharacterFeign characterFeign;

    private final Map<String, TriFunction<HttpServletRequest, Map<String, Object>, ExportReq, ExportDataResponse<?>>> pathMapping = new HashMap<>();
    private final ObjectMapper mapper = new ObjectMapper();

    @PostConstruct
    public void init() {
        register("/character/characterAnalysis/expertKeyWordsCloud/export/excel",
                (request, queryParams, exportReq) ->
                        characterFeign.queryExportExcel(
                                mapper.convertValue(queryParams, ColumnParamSeniorVo.class)
                        ));

        register("/character/characterAnalysis/expertGraph/export/excel",
                (request, queryParams, exportReq) ->
                        characterFeign.expertGraph(
                                mapper.convertValue(queryParams, ColumnParamSeniorVo.class)
                        ));

        register("/character/characterAnalysis/getExpertAcademicInformation/export/excel",
                (request, queryParams, exportReq) ->{

                    String clbToken = request.getHeader("x-access-token");
                    if (clbToken == null || clbToken.isEmpty()) {
                        return new ExportDataResponse<>(2, "x-access-token 不能为空", Collections.emptyList(), Collections.emptyList());
                    }
                    return   characterFeign.getExpertAcademicInformationExport(
                            RequestParamHelper.getParam(queryParams, "uid"),
                            request.getHeader("x-access-token"));
                });


    }

    private void register(String path,
                          TriFunction<HttpServletRequest, Map<String, Object>, ExportReq, ExportDataResponse<?>> func) {
        pathMapping.put(path, (request, queryParams, exportReq) -> {
            try {
                return func.apply(request, queryParams, exportReq);
            } catch (Exception e) {
                // Feign 调用异常或其他不可预期异常统一处理
                return new ExportDataResponse<>(2, "调用 Character 接口失败：" + e.getMessage(),
                        Collections.emptyList(), Collections.emptyList());
            }
        });
    }

    @Override
    public String getServiceName() {
        return "character-analysis";
    }

    @Override
    public String getApiPath() {
        return null; // 所有接口由本策略处理
    }

    @Override
    public ExportDataResponse<?> execute(HttpServletRequest request, Map<String, Object> queryParams, ExportReq exportReq) {
        TriFunction<HttpServletRequest, Map<String, Object>, ExportReq, ExportDataResponse<?>> func =
                pathMapping.get(exportReq.getApiPath());
        if (func == null) {
            return new ExportDataResponse<>(404, "未找到匹配的接口: " + exportReq.getApiPath(),
                    Collections.emptyList(), Collections.emptyList());
        }
        return func.apply(request, queryParams, exportReq);
    }
}

