package com.zzsn.excelexportservice.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author kongliufeng
 * @create 2021-11-08
 */
@Data
public class Result<T>  implements Serializable {

    private static final long serialVersionUID = 1L;
    private int errorcode = 0;
    private String msg;
    private T model;

    public Result() {

    }

    public static<T> Result<T> OK() {
        Result<T> r = new Result<T>();
        r.setErrorcode(0);
        r.setMsg("success");
        return r;
    }

    public static<T> Result<T> OK(T data) {
        Result<T> r = new Result<T>();
        r.setErrorcode(0);
        r.setMsg("success");
        r.setModel(data);
        return r;
    }

    public static<T> Result<T> OK(String msg, T data) {
        Result<T> r = new Result<T>();
        r.setErrorcode(0);
        r.setMsg(msg);
        r.setModel(data);
        return r;
    }

    public static<T> Result<T> error() {
        Result<T> r = new Result<T>();
        r.setErrorcode(1);
        r.setMsg("fail");
        return r;
    }

    public static<T> Result<T> error(String msg) {
        Result<T> r = new Result<T>();
        r.setErrorcode(1);
        r.setMsg(msg);
        return r;
    }

    public static<T> Result<T> error(String msg, T data) {
        Result<T> r = new Result<T>();
        r.setErrorcode(0);
        r.setMsg(msg);
        r.setModel(data);
        return r;
    }

}
