package com.zzsn.excelexportservice.feign;

/**
 * @Author: lxj
 * @Date: 2025/9/26 11:46
 */

import com.zzsn.excelexportservice.dto.ColumnParamSeniorVo;
import com.zzsn.excelexportservice.dto.ExportDataResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: lxj
 * @Date: 2025/9/26 11:46
 */
@FeignClient(name = "character-analysis"
        , url = "${excel.export.services.character-analysis.data-url}"
)
public interface CharacterFeign {

    @PostMapping("/character/characterAnalysis/expertKeyWordsCloud/export/excel")
    ExportDataResponse queryExportExcel(@RequestBody ColumnParamSeniorVo columnParamVO);

    @PostMapping("/character/characterAnalysis/expertGraph/export/excel")
    ExportDataResponse expertGraph(@RequestBody ColumnParamSeniorVo columnParamVO);

    @GetMapping("/character/characterAnalysis/getExpertAcademicInformation/export/excel")
    ExportDataResponse<?> getExpertAcademicInformationExport(
            @RequestParam("uid") String uid,
            @RequestHeader("x-access-token") String clbToken
    );
}
