package com.zzsn.excelexportservice.config;

import feign.Request;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;


@Configuration
public class FeignConfig implements RequestInterceptor {
    @Override
    public void apply(RequestTemplate template) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return; // 当前不是来自前端请求时（比如定时任务）就不加
        }

        HttpServletRequest request = ((ServletRequestAttributes) requestAttributes).getRequest();
        String token = request.getHeader("Accesstoken"); // 或者 "token"

        if (token != null) {
            template.header("Accesstoken", token);
        }
    }

    @Value("${feign.client.config.default.connectTimeout}")
    private int connectTimeout;
    @Value("${feign.client.config.default.readTimeout}")
    private int readTimeout;

    @Bean
    public Request.Options options() {
        return new Request.Options(
                connectTimeout,
                readTimeout
        );
    }


}
