package com.zzsn.thinktank.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Collections;
import java.util.List;

/**
 * @Author: lxj
 * @Date: 2025/9/19 16:24
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ExportDataResponse<T> {
    private int code;
    private String msg;
    private List<Header> headers;
    private List<T> dataList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Header {
        private String field;
        private String title;
    }

    // 处理失败的 Result
    public static <T> ExportDataResponse<T> fromResultFail(Result<?> result) {
        ExportDataResponse<T> resp = new ExportDataResponse<>();
        resp.setCode(result.getCode());   // 自定义失败码
        resp.setMsg(result.getMessage());
        resp.setHeaders(Collections.emptyList());
        resp.setDataList(Collections.emptyList());
        return resp;
    }


    public static <T> ExportDataResponse<T> success(List<Header> headers,List<T> dataList) {
        ExportDataResponse<T> resp = new ExportDataResponse<>();
        resp.setCode(0);   // 自定义失败码
        resp.setMsg("success");
        resp.setHeaders(headers);
        resp.setDataList(dataList);
        return resp;
    }
}
