package com.zzsn.thinktank.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.thinktank.entity.InfoSource;
import com.zzsn.thinktank.vo.InfoSourceVo;

import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/4/25 9:43
 * @Content:
 */
public interface InfoSourceService extends IService<InfoSource> {
    /**
     * 根据分类id获取信息源列表(ynBind=0 :查询没有绑定该组的信息源列表  ynBind=1 :查询绑定该组的信息源列表 )
     */
    IPage<InfoSourceVo> pageListByGroupId (InfoSourceVo infoSourceVo, Integer ynBind, String groupId, Integer pageNo, Integer pageSize);

    /**
     * 根据分类id获取信息源列表
     */
    IPage<InfoSourceVo> pageListByTypeId (String customerId, String userId, InfoSourceVo infoSourceVo, Integer pageNo, Integer pageSize, String infoSourceTypeId);

    /**
     * 获取信息源组下的信息源id集合
     */
    List<String> listByGroupId(String groupId);
}
