package com.zzsn.thinktank.util;

import com.github.stuxuhai.jpinyin.PinyinFormat;

/**
 * 汉字拼音工具类
 *
 * @author lkg
 * @date 2023/4/10
 */
public class PinYinUtil {

    /**
     * 获取首字母(大写)--根据词义准确抽取
     *
     * @param str 汉字
     * @author lkg
     * @date 2023/4/10
     */
    public static String getInitialByWordMean(String str){
        String initial = null;
        try {
            String shortPinyin = com.github.stuxuhai.jpinyin.PinyinHelper.getShortPinyin(str);
            initial = String.valueOf(shortPinyin.charAt(0)).toUpperCase();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return initial;
    }

    /**
     * 抽取拼音--根据词义准确抽取
     *
     * @param str 词
     * @param type 1-全拼;2-简拼(各字的首字母)
     * @author lkg
     * @date 2024/3/26
     */
    public static String getPinYinByWordMean(String str,Integer type){
        String pinyin = null;
        try {
            if (type == 1) {
                pinyin = com.github.stuxuhai.jpinyin.PinyinHelper.convertToPinyinString(str, "", PinyinFormat.WITHOUT_TONE);
            } else {
                pinyin = com.github.stuxuhai.jpinyin.PinyinHelper.getShortPinyin(str);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return pinyin;
    }
}
