package com.zzsn.thinktank.config;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.zzsn.thinktank.config.interceptor.DataPermitInterceptor;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 整合 fastjson
 * @author yanxin
 * @date 2022年6月20日19:07:31
 */
@Configuration
@EnableWebMvc
public class WebConfig implements WebMvcConfigurer {

    //注入自定义拦截器
    @Resource
    DataPermitInterceptor dataPermitInterceptor;
    @Override
    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        FastJsonHttpMessageConverter fastJsonHttpMessageConverter = new FastJsonHttpMessageConverter();
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        fastJsonConfig.setSerializeFilters(new ValueFilter() {
            @Override
            public Object process(Object object, String name, Object value) {
                if (value == null){
                    //如果需要返回null值，则此处返回""即可
                    return "";
                }
                if (value instanceof Date){
                    return DateUtil.format((Date) value,"yyyy-MM-dd HH:mm:ss");
                }
                return value;
            }
        });
        fastJsonHttpMessageConverter.setFastJsonConfig(fastJsonConfig);
        List<MediaType> mediaTypes = new ArrayList<>();
        mediaTypes.add(MediaType.APPLICATION_JSON_UTF8);
        fastJsonHttpMessageConverter.setSupportedMediaTypes(mediaTypes);
        converters.add(fastJsonHttpMessageConverter);
    }



    @Override
    public void addInterceptors(InterceptorRegistry registry) {
     /*   registry.addInterceptor(dataPermitInterceptor)
                .addPathPatterns("/**")
                .excludePathPatterns("/LoginController/**", "/error");//放行路径
    */

        WebMvcConfigurer.super.addInterceptors(registry);
    }
    @Override
    public void addCorsMappings(CorsRegistry registry){
        registry.addMapping("/**")
                .allowedOrigins("*")
                .allowedMethods("*")
                .allowedHeaders("*");

    }
}