package com.zzsn.thinktank;

import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.thinktank.entity.InfoSourceGroupMap;
import com.zzsn.thinktank.entity.InfoSourceMain;
import com.zzsn.thinktank.entity.ThinktankBasicInfo;
import com.zzsn.thinktank.service.*;
import com.zzsn.thinktank.vo.DataChangeVO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@SpringBootTest
class ThinkTankApplicationTests {

    @Autowired
    private ThinktankBasicInfoService thinktankBasicInfoService;
    @Resource
    private DataImportService dataImportService;

    @Test
    void contextLoads() {
        List<DataChangeVO> influencePositionList = dataImportService.dictItemList("Influence");
        Map<String, String> influencePositionMap = influencePositionList.stream().collect(Collectors.toMap(DataChangeVO::getDescription, DataChangeVO::getValue, (value1, value2) -> value1));
        LambdaQueryWrapper<ThinktankBasicInfo> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.select(ThinktankBasicInfo::getId, ThinktankBasicInfo::getInfluencePosition);
        List<ThinktankBasicInfo> list = thinktankBasicInfoService.list(queryWrapper);
        for (int i = 0; i < list.size(); i++) {
            ThinktankBasicInfo thinktankBasicInfo = list.get(i);
            String influencePosition = thinktankBasicInfo.getInfluencePosition();
            if (influencePosition != null) {
                StringBuilder sb = new StringBuilder();
                for (String s : influencePosition.split(",")) {
                    String value = influencePositionMap.get(s);
                    sb.append(",").append(value);
                }
                thinktankBasicInfo.setInfluencePosition(sb.substring(1));
            }
            log.info("共-{}，第-{}个,更新完成", list.size(), i + 1);
        }
        thinktankBasicInfoService.updateBatchById(list);
        System.out.println("结束");
    }

    @Autowired
    private InfoSourceGroupMapService infoSourceGroupMapService;
    @Autowired
    private InfoSourceMainService infoSourceMainService;

    @Test
    public void handlerBindData() {
        ExcelReader reader = ExcelUtil.getReader("C:\\Users\\lenovo\\Desktop\\202509智库优化信息源绑定.xlsx", 0);
        List<List<Object>> read = reader.read(1,296);
        for (List<Object> objects : read) {
            String code = objects.get(0).toString();
            String infoSourceCode = objects.get(6).toString();
            if (StringUtils.isNotEmpty(code) && StringUtils.isNotEmpty(infoSourceCode)) {
                LambdaQueryWrapper<ThinktankBasicInfo> wrapper = Wrappers.lambdaQuery();
                wrapper.eq(ThinktankBasicInfo::getCodeId, code);
                ThinktankBasicInfo one = thinktankBasicInfoService.getOne(wrapper);
                if (one != null) {
                    LambdaQueryWrapper<InfoSourceMain> query = Wrappers.lambdaQuery();
                    query.eq(InfoSourceMain::getCode, infoSourceCode);
                    InfoSourceMain infoSourceMain = infoSourceMainService.getOne(query);
                    if (infoSourceMain != null) {
                        LambdaQueryWrapper<InfoSourceGroupMap> queryWrapper = Wrappers.lambdaQuery();
                        String infoSourceId = infoSourceMain.getId();
                        queryWrapper.eq(InfoSourceGroupMap::getGroupId, one.getId()).eq(InfoSourceGroupMap::getSourceId, infoSourceId);
                        int count = infoSourceGroupMapService.count(queryWrapper);
                        if (count == 0) {
                            InfoSourceGroupMap infoSourceGroupMap = new InfoSourceGroupMap();
                            infoSourceGroupMap.setGroupId(one.getId());
                            infoSourceGroupMap.setSourceId(infoSourceId);
                            infoSourceGroupMap.setType(31);
                            infoSourceGroupMap.setCreateTime(new Date());
                            infoSourceGroupMapService.save(infoSourceGroupMap);
                        }
                        log.info("{},智库绑定信息源处理完毕", one.getChineseWhole());
                    } else {
                        log.info("{},信息源未找到", infoSourceCode);
                    }
                } else {
                    log.info("{},智库未找到", code);
                }
            } else {
                log.info("数据为空");
            }
            //break;
        }
    }
}
