#!/bin/sh

set -eu

source ${PWD}/config.sh

# version="T1.0.0-$(date +'%Y%m%d-%H%M%S')"
version="latest"
domain="${repo_domain}"
namespace="${repo_namespace}"
username="${repo_username}"
passwd="${repo_passwd}"
dir="/zzsn/think-tank/test"
name="think-tank-test"

echo "运行程序"

if [ "$(docker ps -aqf "name=^${name}")" ]; then
    # 如果存在，则停止并删除容器
    echo "停止并删除容器: ${name}"
    docker rm -f "${name}"
else
    echo "容器不存在直接运行: ${name}"
fi

# 运行测试环境
docker run --restart always -d -p 9099:9099 --name ${name} \
-v /etc/localtime:/etc/localtime:ro \
-v ${dir}/logs:/clbLogs/thinktank \
${domain}/${namespace}/${name}:${version}