package com.zzsn.thinktank.vo;

import lombok.Data;

import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/29 17:54
 * @Content:
 */
@Data
public class ThinktankBasicInfoListVo {

    //当前页码，默认值为1
    private Integer pageNo = 1;

    //分页偏移量 根据 pageNo 和 pageSize 计算得到
    private Integer offset;

    //每页数量，默认值为10
    private Integer pageSize = 10;

    //排序字段，多个排序字段用逗号分隔
    private String column = "id";
    //降序DESC 升序 ASC 默认为DESC
    private String order = "DESC";

    //关键词
    private String keyword;

    //智库机构编码
    private String codeId;

    //智库机构名称
    private String thinktankName;

    //类别 根据左侧树id
    private String typeId;

    //标签
    private String tagId;
    //智库id，多个逗号隔开
    private String id;


    //区域国家标签id
    private List<String> regionalCountriesTypeId;
    //领域标签id
    private List<String> fieldTypeId;
    //语言
    private List<String> langList;
    //智库性质
    private List<String> natureList;
    //影响力和地位
    private List<String> influencePositionList;
    //智库规模
    private List<String> scaleList;
    //人员规模
    private List<String> staffSizeList;
    //运营状态
    private List<String> operateStatusList;
}
