package com.zzsn.thinktank.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.thinktank.entity.ThinktankBasicInfo;
import com.zzsn.thinktank.vo.ThinktankBasicInfoExportVo;
import com.zzsn.thinktank.vo.ThinktankBasicInfoListVo;
import com.zzsn.thinktank.vo.ThinktankBasicInfoVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/4/24 10:34
 * @Content:
 */
@Mapper
public interface ThinktankBasicInfoMapper extends BaseMapper<ThinktankBasicInfo> {
    List<ThinktankBasicInfoVo> getList(ThinktankBasicInfoListVo thinktankBasicInfoListVo);

    Integer getCount(ThinktankBasicInfoListVo thinktankBasicInfoListVo);

    List<ThinktankBasicInfoExportVo> getExportList(ThinktankBasicInfoListVo thinktankBasicInfoListVo);

    /**
     * 根据id更新智库基本信息
     * @param id 智库id
     * @param lang 语言
     * @param profitNature 盈利性质
     * @param nature 智库性质
     * @param influencePosition 影响力和地位
     * @param scale 智库规模
     */
    @Update("update thinktank_basic_info set lang = #{lang},profit_nature = #{profitNature},nature = #{nature},influence_position = #{influencePosition},scale = #{scale} where id = #{id} ")
    void updateThinkTankBasicInfoById(@Param("id") String id,
                                      @Param("lang")String lang,
                                      @Param("profitNature")String profitNature,
                                      @Param("nature")String nature,
                                      @Param("influencePosition")String influencePosition,
                                      @Param("scale")String scale);
}
