package com.zzsn.thinktank.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zs
 * @Description 信息源/信息源组 枚举
 * @since 2021/12/9
 */
public enum BindTypeEnum {


    INFO_SOURCE(1,"绑定的通用信息源栏目"),

    INFO_SOURCE_GROUP(2,"绑定的通用信息源栏目组"),

    EXCLUDE_INFO_SOURCE(3,"排除的信息源栏目"),

    EXCLUDE_INFO_SOURCE_GROUP(4,"排除的信息源栏目组"),

    DIRECTIONA_INFO_SOURCE_GROUP(5,"定向的信息源栏目组"),
    DIRECTIONA_INFO_SOURCE(6,"定向的信息源栏目"),
    INFO_SOURCE_LABEL(12,"通用信息源栏目标签"),
    EXCLUDE_INFO_SOURCE_LABEL(14,"排除信息源栏目标签"),
    DIRECTIONA_INFO_SOURCE_LABEL(15,"定向信息源栏目标签"),

    INFO_MAIN_SOURCE(31,"绑定的通用信息源"),

    INFO_MAIN_SOURCE_GROUP(32,"绑定的通用信息源组"),

    EXCLUDE_MAIN_INFO_SOURCE(33,"排除的信息源"),

    EXCLUDE_MAIN_INFO_SOURCE_GROUP(34,"排除的信息源组"),

    DIRECTIONA_MAIN_INFO_SOURCE_GROUP(35,"定向的信息源组"),
    DIRECTIONA_MAIN_INFO_SOURCE(36,"定向的信息源"),
    INFO_SOURCE_MAIN_LABEL(312,"通用信息源标签"),
    EXCLUDE_INFO_MAIN_SOURCE_LABEL(314,"排除信息源标签"),
    DIRECTIONA_INFO_MAIN_SOURCE_LABEL(315,"定向信息源标签")

    ;

    private Integer value;
    private String des;

    BindTypeEnum(int value, String des) {
        this.value = value;
        this.des = des;
    }

    public Integer getvalue() {
        return value;
    }

    public String getDes() {
        return des;
    }



    //定向、通用、屏蔽信息源栏目组类型返回
    public static List<Integer> getInfoSourceGroupType() {
        List<Integer> values = new ArrayList<>();
        values.add(BindTypeEnum.INFO_SOURCE_GROUP.getvalue());
        values.add(BindTypeEnum.EXCLUDE_INFO_SOURCE_GROUP.getvalue());
        values.add(BindTypeEnum.DIRECTIONA_INFO_SOURCE_GROUP.getvalue());
        return values;
    }
    //定向、通用、屏蔽信息源类栏目型返回
    public static List<Integer> getInfoSourceType() {
        List<Integer> values = new ArrayList<>();
        values.add(BindTypeEnum.INFO_SOURCE.getvalue());
        values.add(BindTypeEnum.EXCLUDE_INFO_SOURCE.getvalue());
        values.add(BindTypeEnum.DIRECTIONA_INFO_SOURCE.getvalue());
        return values;
    }
    //定向、通用、屏蔽 信息源栏目标签类型返回
    public static List<Integer> getInfoSourceLabelType() {
        List<Integer> values = new ArrayList<>();
        values.add(BindTypeEnum.INFO_SOURCE_LABEL.getvalue());
        values.add(BindTypeEnum.EXCLUDE_INFO_SOURCE_LABEL.getvalue());
        values.add(BindTypeEnum.DIRECTIONA_INFO_SOURCE_LABEL.getvalue());
        return values;
    }
    //定向、通用、屏蔽信息源组类型返回
    public static List<Integer> getInfoSourceMainGroupType() {
        List<Integer> values = new ArrayList<>();
        values.add(BindTypeEnum.INFO_MAIN_SOURCE_GROUP.getvalue());
        values.add(BindTypeEnum.EXCLUDE_MAIN_INFO_SOURCE_GROUP.getvalue());
        values.add(BindTypeEnum.DIRECTIONA_MAIN_INFO_SOURCE_GROUP.getvalue());
        return values;
    }
    //定向、通用、屏蔽信息源类型返回
    public static List<Integer> getInfoSourceMainType() {
        List<Integer> values = new ArrayList<>();
        values.add(BindTypeEnum.INFO_MAIN_SOURCE.getvalue());
        values.add(BindTypeEnum.EXCLUDE_MAIN_INFO_SOURCE.getvalue());
        values.add(BindTypeEnum.DIRECTIONA_MAIN_INFO_SOURCE.getvalue());
        return values;
    }
    //定向、通用、屏蔽 信息源标签类型返回
    public static List<Integer> getInfoSourceMainLabelType() {
        List<Integer> values = new ArrayList<>();
        values.add(BindTypeEnum.INFO_SOURCE_MAIN_LABEL.getvalue());
        values.add(BindTypeEnum.EXCLUDE_INFO_MAIN_SOURCE_LABEL.getvalue());
        values.add(BindTypeEnum.DIRECTIONA_INFO_MAIN_SOURCE_LABEL.getvalue());
        return values;
    }



    public static BindTypeEnum getEnumByValue(Integer value) {
        for (BindTypeEnum bindTypeEnum : BindTypeEnum.values()) {
            if (bindTypeEnum.getvalue().equals(value)) {
                return bindTypeEnum;
            }
        }
        return null;
    }
}
