package com.zzsn.thinktank.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 *5.1 人物分类体系表 character_category_structure
 * </p>
 *
 * @since
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("thinktank_category_structure")
public class ThinktankCategoryStructure extends Model<ThinktankCategoryStructure>
 {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 类别名称 公安部 财政部
     */
    @TableField("type_name")
    private String typeName;

    /**
     *类别编码
     */
    @TableField("type_code")
    private String typeCode;

    /**
     * 创建人
     */
    @TableField("create_by")
    private String createBy;

    /**
     * 创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    //@TableField("create_time")
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新人
     */
    @TableField("update_by")
    private String updateBy;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    //@TableField("update_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /**
     * 所属部门
     */
    @TableField("sys_org_code")
    private String sysOrgCode;

    /**
     * 父级节点id
     */
    @TableField("pid")
    private String pid;

    /**
     * 是否有子节点0，没有 1，有
     */
    @TableField("has_child")
    private String hasChild;

    /**
     * 分类类型:	领导人 专家 企业高管
     */
    @TableField("category")
    private String category;

    /**
     * 状态0启用，1禁用
     */
    @TableField("status")
    private Integer status;

    /**
     * 节点绝对路径
     */
    @TableField("full_path")
    private String fullPath;

    /**
     * 描述
     */
    @TableField("description")
    private String description;

    /**
     * 排序
     */
    @TableField("sort")
    private Long sort;

}
