package com.zzsn.thinktank.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.thinktank.entity.InfoSource;
import com.zzsn.thinktank.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/4/25 9:50
 * @Content:
 */
@Mapper
public interface InfoSourceMapper extends BaseMapper<InfoSource> {

    List<InfoSourceVo> pageListByGroupId(@Param("infoSourceVo") InfoSourceVo infoSourceVo, @Param("ynBind") Integer ynBind, @Param("groupId") String groupId, @Param("offset") Integer offset, @Param("pageSize") Integer pageSize);

    Integer totalCountByGroupId(@Param("infoSourceVo") InfoSourceVo infoSourceVo, @Param("ynBind") Integer ynBind, @Param("groupId") String groupId);

    List<InfoSourceVo> pageList(@Param("customerId") String customerId, @Param("userId") String userId, @Param("infoSourceVo") InfoSourceVo infoSourceVo, @Param("typeIds") List<String> typeIds, @Param("offset") Integer offset, @Param("pageSize") Integer pageSize);

    List<InfoSourceVo> listBySidList(@Param("customerId") String customerId, @Param("userId") String userId, List<String> collect);

    Integer totalCount(@Param("customerId") String customerId, @Param("userId") String userId, @Param("infoSourceVo") InfoSourceVo infoSourceVo, @Param("typeIds") List<String> typeIds);

    List<String> listByGroupId(@Param("groupId") String groupId);

    /**
     * 智库绑定信息源分页列表
     *
     * @param thinkTankId         智库id
     * @param infoSearchCondition 检索条件
     * @param page                分页信息
     * @author lkg
     * @date 2025/8/2
     */
    IPage<BindInfoSourceVO> bindInfoSourcePageList(@Param("thinkTankId") String thinkTankId, @Param("infoSearchCondition") InfoSearchCondition infoSearchCondition, Page<BindInfoSourceVO> page);

    /**
     * 智库绑定信息源栏目分页列表
     *
     * @param thinkTankId         智库id
     * @param infoSearchCondition 检索条件
     * @param page                分页信息
     * @author lkg
     * @date 2025/8/2
     */
    IPage<BindInfoSourceColumnVO> bindInfoSourceColumnPageList(@Param("thinkTankId") String thinkTankId, @Param("infoSearchCondition") InfoSearchCondition infoSearchCondition, Page<BindInfoSourceColumnVO> page);

    /**
     * 智库绑定信息源栏目列表
     *
     * @param thinkTankId         智库id
     * @param infoSearchCondition 检索条件
     * @author lkg
     * @date 2025/8/2
     */
    List<BindInfoSourceColumnVO> bindInfoSourceColumnPageList(@Param("thinkTankId") String thinkTankId, @Param("infoSearchCondition") InfoSearchCondition infoSearchCondition);

    /**
     * 智库绑定信息源组列表
     *
     * @param thinkTankId 智库id
     * @param types       信息源类型
     * @author lkg
     * @date 2025/8/2
     */
    List<InfoSourceGroupVO> bindInfoSourceGroupList(@Param("thinkTankId") String thinkTankId, @Param("types") List<Integer> types);

    /**
     * 智库绑定信息源列表
     *
     * @param thinkTankId 智库id
     * @param types       信息源类型
     * @author lkg
     * @date 2025/8/2
     */
    List<BindInfoSourceVO> bindInfoSourceList(@Param("thinkTankId") String thinkTankId, @Param("types") List<Integer> types);

    /**
     * 智库绑定信息源/信息源栏目标签列表
     *
     * @param thinkTankId 智库id
     * @param types       信息源类型
     * @author lkg
     * @date 2025/8/2
     */
    List<InfoSourceLabelVO> bindInfoSourceLabelList(@Param("thinkTankId") String thinkTankId, @Param("types") List<Integer> types);

    /**
     * 智库绑定信息源栏目组列表
     *
     * @param thinkTankId 智库id
     * @param types       信息源类型
     * @author lkg
     * @date 2025/8/2
     */
    List<InfoSourceGroupVO> bindInfoSourceColumnGroupList(@Param("thinkTankId") String thinkTankId, @Param("types") List<Integer> types);

    /**
     * 智库绑定信息源栏目列表
     *
     * @param thinkTankId 智库id
     * @param types       信息源类型
     * @author lkg
     * @date 2025/8/2
     */
    List<BindInfoSourceColumnVO> bindInfoSourceColumnList(@Param("thinkTankId") String thinkTankId, @Param("types") List<Integer> types);

    /**
     * 获取智库绑定信息源的数量
     *
     * @param thinkTankIds 智库id集合
     * @author lkg
     * @date 2025/8/5
     */
    List<BindSourceDetailVO> bindSourceCount(@Param("thinkTankIds") List<String> thinkTankIds);

}
