package com.zzsn.thinktank.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.thinktank.entity.LabelEntity;
import com.zzsn.thinktank.entity.SysBaseLabelType;
import com.zzsn.thinktank.vo.SysBaseLabelTypeVo;
import com.zzsn.thinktank.vo.SysLabelVo;
import com.zzsn.thinktank.entity.ThinktankTagTop;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/21 11:05
 * @Content:
 */
@Mapper
public interface ThinktankTagMapper extends BaseMapper<LabelEntity> {


    List<ThinktankTagTop> getTopTag();

    SysBaseLabelType getSysBaseLabelTypeById(String id);

    List<SysBaseLabelType> getgetSysBaseLabelTypeListByPid(String id);

    List<SysLabelVo> queryCustomLabel(List<String> ids, String name);

    List<SysBaseLabelTypeVo> getTagTypeListAll();

    @Select("select * from thinktank_tag_top " +
            "where 1=1 " +
            "and id = #{tagId} " +
            "limit 1")
    ThinktankTagTop getById(String tagName);

    @Select("select max(sort) from label_entity where pid = #{pid}")
    Integer queryMaxOrderNo(String pid);

}
