package com.zzsn.thinktank.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.thinktank.entity.InfoSourceGroupMap;
import com.zzsn.thinktank.entity.ThinktankBasicInfo;
import com.zzsn.thinktank.enums.BindTypeEnum;
import com.zzsn.thinktank.mapper.InfoSourceGroupMapMapper;
import com.zzsn.thinktank.service.InfoSourceGroupMapService;
import com.zzsn.thinktank.vo.BindLabelVo;
import com.zzsn.thinktank.vo.BindVO;
import com.zzsn.thinktank.vo.InfoSourceGroupPage;
import com.zzsn.thinktank.vo.ThinkTankSourceVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * @Description: 信息源组和信息源关联表
 * @Author:
 * @Date:
 * @Version:
 */
@Service
public class InfoSourceGroupMapServiceImpl extends ServiceImpl<InfoSourceGroupMapMapper, InfoSourceGroupMap> implements InfoSourceGroupMapService {

    @Override
    @Transactional //抛出异常回滚
    public String bind(String groupId, List<String> sourceIds) {
        String message = "绑定成功！";
        if (!StringUtils.isEmpty(groupId) && sourceIds != null && sourceIds.size() > 0) {
            for (String sourceId : sourceIds) {
                //判断是否绑定过
                QueryWrapper<InfoSourceGroupMap> queryWrapper = new QueryWrapper<InfoSourceGroupMap>();
                queryWrapper.eq("group_id", groupId);
                queryWrapper.eq("source_id", sourceId);
                //todo:query in loop
                List<InfoSourceGroupMap> list = baseMapper.selectList(queryWrapper);
                if (list.size() <= 0) {
                    InfoSourceGroupMap infoSourceGroupMap = new InfoSourceGroupMap();
                    infoSourceGroupMap.setGroupId(groupId);
                    infoSourceGroupMap.setSourceId(sourceId);
                    baseMapper.insert(infoSourceGroupMap);
                } else {
                    message = "部分已经绑定信息源成功过滤，未绑定的信息源已经绑定！";
                }
            }
        }
        return message;
    }

    @Override
    public void unBind(String groupId, List<String> sourceIds) {
        if (!StringUtils.isEmpty(groupId) && sourceIds != null && sourceIds.size() > 0) {
            baseMapper.deleteBySourceIds(groupId, sourceIds);
        }
    }

    @Override
    public List<InfoSourceGroupMap> getSourceGroupMap(List groupIds) {

        LambdaQueryWrapper<InfoSourceGroupMap> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.in(InfoSourceGroupMap::getGroupId, groupIds);
        List<InfoSourceGroupMap> list = baseMapper.selectList(lambdaQuery);
        return list;
    }

    @Override
    public List<ThinkTankSourceVO> listOfThinkTank(List<String> groupIds) {
        return baseMapper.listOfThinkTank(groupIds);
    }

    @Override
    public void bind(BindVO bindVO) {
        //绑定信息源栏目组
        if (bindVO.getSourceType() == 1) {
            bindInfoSourceColumnGroup(bindVO);
        }
        //绑定信息源栏目
        if (bindVO.getSourceType() == 2) {
            bindInfoSourceColumn(bindVO);
        }
        //绑定栏目标签
        if (bindVO.getSourceType() == 3) {
            bindInfoSourceColumnLabels(bindVO);
        }
        //绑定信息源组
        if (bindVO.getSourceType() == 4) {
            bindInfoSourceGroup(bindVO);
        }
        //绑定信息源
        if (bindVO.getSourceType() == 5) {
            bindInfoSource(bindVO);
        }
        //绑定信息源标签
        if (bindVO.getSourceType() == 6) {
            bindInfoSourceLabels(bindVO);
        }
    }

    @Override
    public void unBind(BindVO bindVO) {

        //解绑信息源栏目组
        if (bindVO.getSourceType() == 1) {
            unBindInfoSourceColumnGroup(bindVO);
        }
        //解绑信息源栏目
        if (bindVO.getSourceType() == 2) {
            unBindInfoSourceColumn(bindVO);
        }
        //解绑信息源栏目标签
        if (bindVO.getSourceType() == 3) {
            unBindInfoSourceColumnLabels(bindVO);
        }
        //解绑信息源组
        if (bindVO.getSourceType() == 4) {
            unBindInfoSourceGroup(bindVO);
        }
        //解绑信息源
        if (bindVO.getSourceType() == 5) {
            unBindInfoSource(bindVO);
        }
        //解绑信息源标签
        if (bindVO.getSourceType() == 6) {
            unBindInfoSourceLabels(bindVO);
        }
    }

    private void unBindInfoSourceColumnGroup(BindVO bindVO) {
        Integer sourceBindType = bindVO.getSourceBindType();
        List<String> idList = bindVO.getBindIds();
        if(CollectionUtil.isEmpty(idList)){
            return ;
        }
        if (sourceBindType == 1) {
            //解绑通用信息源组
            unBindInfoSource(bindVO, BindTypeEnum.INFO_SOURCE_GROUP.getvalue());
        }
        if (sourceBindType == 2) {
            //解绑定向信息源组
            unBindInfoSource(bindVO,BindTypeEnum.DIRECTIONA_INFO_SOURCE_GROUP.getvalue());
        }
    }
    private void unBindInfoSourceColumn(BindVO bindVO) {
        Integer sourceBindType = bindVO.getSourceBindType();
        List<String> idList = bindVO.getBindIds();
        if(CollectionUtil.isEmpty(idList)){
            return ;
        }
        if (sourceBindType == 1) {
            //解绑通用信息源组
            unBindInfoSource(bindVO, BindTypeEnum.INFO_SOURCE.getvalue());
        }
        if (sourceBindType == 2) {
            //解绑定向信息源组
            unBindInfoSource(bindVO,BindTypeEnum.DIRECTIONA_INFO_SOURCE.getvalue());
        }
    }

    private void unBindInfoSourceGroup(BindVO bindVO) {
        Integer sourceBindType = bindVO.getSourceBindType();
        List<String> idList = bindVO.getBindIds();
        if(CollectionUtil.isEmpty(idList)){
            return ;
        }
        if (sourceBindType == 1) {
            //解绑通用信息源组
            unBindInfoSource(bindVO, BindTypeEnum.INFO_MAIN_SOURCE_GROUP.getvalue());
        }
        if (sourceBindType == 2) {
            //解绑定向信息源组
            unBindInfoSource(bindVO,BindTypeEnum.DIRECTIONA_MAIN_INFO_SOURCE_GROUP.getvalue());
        }
    }
    private void unBindInfoSource(BindVO bindVO) {
        Integer sourceBindType = bindVO.getSourceBindType();
        List<String> idList = bindVO.getBindIds();
        if(CollectionUtil.isEmpty(idList)){
            return ;
        }
        if (sourceBindType == 1) {
            //解绑通用信息源
            unBindInfoSource(bindVO, BindTypeEnum.INFO_MAIN_SOURCE.getvalue());
        }
        if (sourceBindType == 2) {
            //解绑定向信息源
            unBindInfoSource(bindVO,BindTypeEnum.DIRECTIONA_MAIN_INFO_SOURCE.getvalue());
        }
    }

    private void unBindInfoSourceColumnLabels(BindVO bindVO) {
        Integer sourceBindType = bindVO.getSourceBindType();
        List<BindLabelVo> bindLabels = bindVO.getBindLabels();
        if(CollectionUtil.isEmpty(bindLabels)){
            return ;
        }
        if (sourceBindType == 1) {
            //解绑通用标签
            unBindLabel(bindVO, BindTypeEnum.INFO_SOURCE_LABEL.getvalue());
        }
        if (sourceBindType == 2) {
            //解绑定向标签
            unBindLabel(bindVO, BindTypeEnum.DIRECTIONA_INFO_SOURCE_LABEL.getvalue());
        }
    }
    private void unBindInfoSourceLabels(BindVO bindVO) {
        Integer sourceBindType = bindVO.getSourceBindType();
        List<BindLabelVo> bindLabels = bindVO.getBindLabels();
        if(CollectionUtil.isEmpty(bindLabels)){
            return ;
        }
        if (sourceBindType == 1) {
            //解绑通用标签
            unBindLabel(bindVO, BindTypeEnum.INFO_SOURCE_MAIN_LABEL.getvalue());
        }
        if (sourceBindType == 2) {
            //解绑定向标签
            unBindLabel(bindVO, BindTypeEnum.DIRECTIONA_INFO_MAIN_SOURCE_LABEL.getvalue());
        }
    }

    private void bindInfoSourceColumnGroup(BindVO bindVO) {
        Integer sourceBindType = bindVO.getSourceBindType();
        List<String> idList = bindVO.getBindIds();
        if (CollectionUtil.isEmpty(idList)) {
            return;
        }
        if (sourceBindType == 1) {
            //绑定通用信息源组
            bindInfoSource(bindVO, idList, BindTypeEnum.INFO_SOURCE_GROUP.getvalue());
        }
        if (sourceBindType == 2) {
            //绑定定向信息源组
            bindInfoSource(bindVO, idList, BindTypeEnum.DIRECTIONA_INFO_SOURCE_GROUP.getvalue());
        }
    }

    private void bindInfoSourceColumn(BindVO bindVO) {
        Integer sourceBindType = bindVO.getSourceBindType();
        List<String> idList = bindVO.getBindIds();
        if (CollectionUtil.isEmpty(idList)) {
            return;
        }
        if (sourceBindType == 1) {
            //绑定通用信息源组
            bindInfoSource(bindVO, idList, BindTypeEnum.INFO_SOURCE.getvalue());
        }
        if (sourceBindType == 2) {
            //绑定定向信息源组
            bindInfoSource(bindVO, idList, BindTypeEnum.DIRECTIONA_INFO_SOURCE.getvalue());
        }
    }

    private void bindInfoSourceColumnLabels(BindVO bindVO) {
        String thinkTankId = bindVO.getThinkTankId();
        Integer sourceBindType = bindVO.getSourceBindType();
        List<BindLabelVo> bindLabels = bindVO.getBindLabels();
        if (CollectionUtil.isEmpty(bindLabels)) {
            return;
        }
        if (sourceBindType == 1) {
            //绑定通用标签信息源
            bindLabels(thinkTankId, bindLabels, BindTypeEnum.INFO_SOURCE_LABEL.getvalue());
        }
        if (sourceBindType == 2) {
            //绑定定向标签信息源
            bindLabels(thinkTankId, bindLabels, BindTypeEnum.DIRECTIONA_INFO_SOURCE_LABEL.getvalue());
        }
    }

    private void bindInfoSourceLabels(BindVO bindVO) {
        String thinkTankId = bindVO.getThinkTankId();
        Integer sourceBindType = bindVO.getSourceBindType();
        List<BindLabelVo> bindLabels = bindVO.getBindLabels();
        if (CollectionUtil.isEmpty(bindLabels)) {
            return;
        }
        if (sourceBindType == 1) {
            //绑定通用标签信息源
            bindLabels(thinkTankId, bindLabels, BindTypeEnum.INFO_SOURCE_MAIN_LABEL.getvalue());
        }
        if (sourceBindType == 2) {
            //绑定定向标签信息源
            bindLabels(thinkTankId, bindLabels, BindTypeEnum.DIRECTIONA_INFO_MAIN_SOURCE_LABEL.getvalue());
        }
    }

    private void bindInfoSourceGroup(BindVO bindVO) {
        Integer sourceBindType = bindVO.getSourceBindType();
        List<String> idList = bindVO.getBindIds();
        if (CollectionUtil.isEmpty(idList)) {
            return;
        }
        if (sourceBindType == 1) {
            //绑定通用信息源组
            bindInfoSource(bindVO, idList, BindTypeEnum.INFO_MAIN_SOURCE_GROUP.getvalue());
        }
        if (sourceBindType == 2) {
            //绑定定向信息源组
            bindInfoSource(bindVO, idList, BindTypeEnum.DIRECTIONA_MAIN_INFO_SOURCE_GROUP.getvalue());
        }
    }

    private void bindInfoSource(BindVO bindVO) {
        Integer sourceBindType = bindVO.getSourceBindType();
        List<String> idList = bindVO.getBindIds();
        if (CollectionUtil.isEmpty(idList)) {
            return;
        }
        if (sourceBindType == 1) {
            //绑定通用信息源组
            bindInfoSource(bindVO, idList, BindTypeEnum.INFO_MAIN_SOURCE.getvalue());
        }
        if (sourceBindType == 2) {
            //绑定定向信息源组
            bindInfoSource(bindVO, idList, BindTypeEnum.DIRECTIONA_MAIN_INFO_SOURCE.getvalue());
        }
    }

    private void bindInfoSource(BindVO bindVO, List<String> idList, Integer type) {
        List<InfoSourceGroupMap> mapList = new ArrayList<>();
        String thinkTankId = bindVO.getThinkTankId();
        for (String infoSourceId : idList) {
            InfoSourceGroupMap infoSourceGroupMap = new InfoSourceGroupMap();
            infoSourceGroupMap.setSourceId(infoSourceId);
            infoSourceGroupMap.setGroupId(thinkTankId);
            infoSourceGroupMap.setType(type);
            mapList.add(infoSourceGroupMap);
        }
        this.saveBatch(mapList);
    }

    private void unBindInfoSource(BindVO bindVO, Integer bindType) {
        LambdaQueryWrapper<InfoSourceGroupMap> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(InfoSourceGroupMap::getGroupId, bindVO.getThinkTankId())
                        .eq(InfoSourceGroupMap::getType, bindType)
                                .in(InfoSourceGroupMap::getSourceId, bindVO.getBindIds());
       this.remove(queryWrapper);
    }

    private void bindLabels(String thinkTankId, List<BindLabelVo> bindLabels, Integer bindType) {
        List<InfoSourceGroupMap> mapList = new ArrayList<>();
        for (BindLabelVo infoSourceId : bindLabels) {
            InfoSourceGroupMap infoSourceGroupMap = new InfoSourceGroupMap();
            infoSourceGroupMap.setSourceId(infoSourceId.getLabelCode());
            infoSourceGroupMap.setSourceItemId(infoSourceId.getLabelItemCode());
            infoSourceGroupMap.setGroupId(thinkTankId);
            infoSourceGroupMap.setType(bindType);
            mapList.add(infoSourceGroupMap);
        }
        this.saveBatch(mapList);
    }

    private void unBindLabel(BindVO bindVO, Integer type) {
        List<BindLabelVo> bindLabels = bindVO.getBindLabels();
        if(CollectionUtil.isEmpty(bindLabels)){
            return ;
        }
        Set<String> labelCode = new HashSet<>();
        Set<String> labelItemCode = new HashSet<>();
        for (BindLabelVo bindLabelVo : bindLabels) {
            labelCode.add(bindLabelVo.getLabelCode());
            labelItemCode.add(bindLabelVo.getLabelItemCode());
        }
        this.remove(Wrappers.<InfoSourceGroupMap>lambdaQuery()
                .in(InfoSourceGroupMap::getSourceId,labelCode)
                .in(InfoSourceGroupMap::getSourceItemId,labelItemCode)
                .eq(InfoSourceGroupMap::getGroupId,bindVO.getThinkTankId())
                .eq(InfoSourceGroupMap::getType,type));
    }
}
