package com.zzsn.thinktank.service;

import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.thinktank.entity.InfoSource;
import com.zzsn.thinktank.vo.*;

import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/4/25 9:43
 * @Content:
 */
public interface InfoSourceService extends IService<InfoSource> {
    /**
     * 根据分类id获取信息源列表(ynBind=0 :查询没有绑定该组的信息源列表  ynBind=1 :查询绑定该组的信息源列表 )
     */
    IPage<InfoSourceVo> pageListByGroupId(InfoSourceVo infoSourceVo, Integer ynBind, String groupId, Integer pageNo, Integer pageSize);

    /**
     * 根据分类id获取信息源列表
     */
    IPage<InfoSourceVo> pageListByTypeId(String customerId, String userId, InfoSourceVo infoSourceVo, Integer pageNo, Integer pageSize, String infoSourceTypeId);

    /**
     * 获取信息源组下的信息源id集合
     */
    List<String> listByGroupId(String groupId);

    /**
     * 智库绑定信息源分页列表
     *
     * @param thinkTankId         智库id
     * @param infoSearchCondition 检索条件
     * @param pageNo              页码
     * @param pageSize            每页条数
     * @author lkg
     * @date 2025/8/2
     */
    IPage<BindInfoSourceVO> bindInfoSourcePageList(String thinkTankId, InfoSearchCondition infoSearchCondition, Integer pageNo, Integer pageSize);

    /**
     * 智库绑定信息源栏目分页列表
     *
     * @param thinkTankId         智库id
     * @param infoSearchCondition 检索条件
     * @param pageNo              页码
     * @param pageSize            每页条数
     * @author lkg
     * @date 2025/8/2
     */
    IPage<BindInfoSourceColumnVO> bindInfoSourceColumnPageList(String thinkTankId, InfoSearchCondition infoSearchCondition, Integer pageNo, Integer pageSize);

    /**
     * 智库绑定信息源栏目列表
     *
     * @param thinkTankId         智库id
     * @param infoSearchCondition 检索条件
     * @author lkg
     * @date 2025/8/4
     */
    List<BindInfoSourceColumnVO> bindInfoSourceColumnPageList(String thinkTankId, InfoSearchCondition infoSearchCondition);

    /**
     * 智库绑定信息源组列表
     *
     * @param thinkTankId 智库id
     * @author lkg
     * @date 2025/8/2
     */
    JSONObject bindInfoSourceGroupList(String thinkTankId);

    /**
     * 智库绑定信息源列表
     *
     * @param thinkTankId 智库id
     * @author lkg
     * @date 2025/8/2
     */
    JSONObject bindInfoSourceList(String thinkTankId);

    /**
     * 智库绑定信息源标签列表
     *
     * @param thinkTankId 智库id
     * @param category    类型(1-信息源栏目；2-信息源)
     * @author lkg
     * @date 2025/8/2
     */
    JSONObject bindInfoSourceLabelList(String thinkTankId, Integer category);

    /**
     * 智库绑定信息源栏目组列表
     *
     * @param thinkTankId 智库id
     * @author lkg
     * @date 2025/8/2
     */
    JSONObject bindInfoSourceColumnGroupList(String thinkTankId);

    /**
     * 智库绑定信息源栏目列表
     *
     * @param thinkTankId 智库id
     * @author lkg
     * @date 2025/8/2
     */
    JSONObject bindInfoSourceColumnList(String thinkTankId);

    /**
     * 获取智库绑定信息源栏目统计
     *
     * @param thinkTankIds 智库id集合
     * @author lkg
     * @date 2025/8/5
     */
    List<BindSourceDetailVO> bindSourceDetail(List<String> thinkTankIds);

    /**
     * 获取智库绑定信息源栏目的详细信息
     *
     * @param thinkTankIds 智库id集合
     * @author lkg
     * @date 2025/8/5
     */
    List<ThinkTankSourceVO> bindSourceDetailInfo(List<String> thinkTankIds);
}
