package com.zzsn.thinktank.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Description: 企业基本信息表-新企业表
 */
@Data
@TableName("sys_base_enterprise")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class SysBaseEnterprise implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    private String id;
    /**
     * 统一社会信用代码
     */
    private String socialCreditCode;
    /**
     * 企业原文名称
     */
    private String originalName;
    /**
     * 企业中文名称
     */
    private String name;
    /**
     * 法定代表人
     */
    private String legalPerson;
    /**
     * 电话
     */
    private String officialPhone;
    /**
     * 官网
     */
    private String officialUrl;
    /**
     * 邮箱
     */
    private String officialEmail;
    /**
     * 地址
     */
    private String address;
    /**
     * 简介
     */
    private String briefInfo;
    private String briefInfoTranlate;
    /**
     * 登记状态
     */
    private String registerStatus;
    /**
     * 成立日期
     */
    private String incorporationDate;
    /**
     * 注册资本
     */
    private String capital;
    /**
     * 实缴资本
     */
    private String paidCapital;
    /**
     * 核准日期
     */
    private String approvalDate;
    /**
     * 组织机构代码
     */
    private String organizationCode;
    /**
     * 工商注册号
     */
    private String registerNo;
    /**
     * 纳税人识别号
     */
    private String taxpayerNo;
    /**
     * 企业类型
     */
    private String type;
    /**
     * 营业期限自
     */
    private String businessStartDate;
    /**
     * 营业期限至
     */
    private String businessEndDate;
    /**
     * 纳税人资质
     */
    private String taxpayerQualification;
    /**
     * 所属行业
     */
    private String industry;
    /**
     * 所属地区(来源与爬来的, 存储省市县)
     */
    private String region;
    /***/
    private String regionName;
    /**
     * 所属省
     */
    private String province;
    /**
     * 所属市
     */
    private String city;
    /**
     * 所属县
     */
    private String county;
    /**
     * 登记机关
     */
    private String registerDepartment;
    /**
     * 人员规模
     */
    private String scale;
    /**
     * 参保人数
     */
    private String insured;
    /**
     * 曾用名
     */
    private String beforeName;
    /**
     * 企业简称
     */
    private String shortName;
    /**
     * 英文名
     */
    private String englishName;
    /**
     * 进出口企业代码
     */
    private String importExportEnterpriseCode;
    /**
     * 经营范围
     */
    private String businessRange;
    /**
     * 企业logo地址
     */
    private String logo;
    /**
     * 企查查企业Id
     */
    private String qccId;
    /**
     * 状态: (0保留,1删除)
     */
    private Integer status;
    /**
     * 创建人
     */
    private String createBy;
    /**
     * 创建日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    /**
     * 更新人
     */
    private String updateBy;
    /**
     * 更新日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
    /**
     * 所属部门
     */
    private String sysOrgCode;
    /**
     * 是否国内(1-是;0-否)
     */
    private Integer ynDomestic;
    /**
     * 所属国家/地区名称
     */
    private String countryName;
    /**
     * 信息来源网站的更新日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date sourceUpdateTime;
    /**
     * 名称首字母
     */
    private String initial;


    @TableField(exist = false)
    private Map<String, Object> labelOrder;
    /**
     * 世界500强排序
     */
    @TableField(exist = false)
    private Integer orderTop500;
    /**
     * 是否跳转：0-否 1-是
     */
    @TableField(exist = false)
    private String ifJump;
    /**
     * 股票代码
     */
    @TableField(exist = false)
    private String stockCode;
    /**
     * 标签
     */
//    @TableField(exist = false)
//    private List<Label> labels;
    /**
     * 是否有财务数据, 1-否，1-是 *
     */
    @TableField(exist = false)
    private Integer financeMark;
    /**
     * 股票代码
     */
    @TableField(exist = false)
    private String securitiesCode;
}
