#!/bin/sh

set -eu

. ./.env

dir="${root_dir}/${svc_name}/${svc_env}"
name="${svc_name}-${svc_env}"

echo "运行容器: ${name}"

if [ "$(docker ps -aqf "name=^${name}")" ]; then
    # 如果存在，则停止并删除容器
    echo "停止并删除容器: ${name}"
    docker rm -f "${name}"
else
    echo "容器不存在直接运行: ${name}"
fi

docker run --restart always -d -p 9099:9099 --name ${name} \
-v /etc/localtime:/etc/localtime:ro \
-v ${dir}/logs:/clbLogs/thinktank \
${domain}/${namespace}/${name}:${version}

echo "清理none镜像"
docker image prune -af