package com.zzsn.thinktank.controller;


import com.zzsn.thinktank.entity.ThinktankCategoryStructure;
import com.zzsn.thinktank.service.LeaderCategoryService;
import com.zzsn.thinktank.vo.Result;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 *  分类树前端控制器
 * </p>
 *
 * @author obcy
 * @since 2024-02-27
 */
@Slf4j
@RestController
@RequestMapping("/api/category")
public class LeaderCategoryController {
    @Autowired
    LeaderCategoryService leaderCategoryService;

    /**
     * 根据id查询分类树
     * */
    @GetMapping
    public Result<?> getById(@RequestParam(name="id",required=true) String id){
        log.info("根据id查询分类树:{}",id);
        return Result.OK(leaderCategoryService.getById(id));
    }

    /**
     * 新增分类树
     */
    @PostMapping("/add")
    public Result<?> add(@RequestBody ThinktankCategoryStructure characterCategoryStructure){
        log.info("新增分类树:{}",characterCategoryStructure);
       return leaderCategoryService.add(characterCategoryStructure);
    }
    /**
     * 编辑分类树
     * */
    @PostMapping("/edit")
    public Result<?> edit(@RequestBody ThinktankCategoryStructure characterCategoryStructure){
        log.info("编辑分类树:{}",characterCategoryStructure);
       return leaderCategoryService.edit(characterCategoryStructure);
    }

    /**
     * 删除分类树
     * */
    @GetMapping("/del")
    public Result<?> del(@RequestParam(name="id",required=true) String id){
       log.info("删除分类树:{}",id);
        return leaderCategoryService.del(id);
    }

    /**
     * 查询分类树列表
     * @param sign
     * @param category
     * @param pid
     * @param httpServletRequest
     * @return
     */
    //@GetMapping("/list")
    public Result<?> list(
            @RequestParam(name="sign",defaultValue = "1") String sign,
            @RequestParam(name="category",required = false) String category,
            @RequestParam(name="pid",defaultValue = "0") String pid,
            HttpServletRequest httpServletRequest){
        log.info("查询分类树列表:{}---{}---{}",sign,category,pid);
        if (!"1".equals(sign)){
            if (StringUtils.isBlank(pid)){
                return Result.error("查询非顶级节点列表时需要pid参数");
            }
        }
        return  leaderCategoryService.lists(sign,pid,category);

    }

    @GetMapping("/list")
    public Result<?> list(){
        log.info("查询分类树列表");
        return  leaderCategoryService.lists();

    }

    /**
     * 查询拥有智库资讯数量前十的国家（默认前十）
     */
    @GetMapping("/listTop")
    public Result<?> listTop10(@RequestParam(required = false ,defaultValue = "10") Integer num){
        log.info("查询拥有智库资讯数量前十的国家（默认前十）");
        return  leaderCategoryService.listTop10(num);

    }

    /**
     * 根据名称模糊查询所有节点及父节点
     * @param category
     * @param typeName
     * @return
     */
    @GetMapping("/getByName")
    public Result<?> getByName(
            @RequestParam(name="category",required = false) String category,
            @RequestParam(name="typeName",required=false) String typeName){

        log.info("根据名称模糊查询所有节点及父节点:{}---{}",category,typeName);
        if(typeName == null || "".equals(typeName)){
            //查询全部数据封装成树
            return leaderCategoryService.getAll(category);
        } else {
            //根据typeName模糊查询节点和父节点
            return leaderCategoryService.getByName(category,typeName);
        }
    }

    /**
     * 国家集合信息
     * 所属国家（地区）查询
     * 和左侧树展示的列表一致
     * @return
     */
    @GetMapping("/countryList")
    public Result<?> countryList(){
        return leaderCategoryService.countryList();
    }


//    @GetMapping("/type")
//    public Result<?> type(){
//        return Result.OK(KnowTypeEnum.getAllAsMap());
//    }

}
