package com.zzsn.thinktank.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.zzsn.thinktank.entity.SysDict;
import com.zzsn.thinktank.entity.SysDictItem;
import com.zzsn.thinktank.mapper.SysDictItemMapper;
import com.zzsn.thinktank.service.ISysDictItemService;
import com.zzsn.thinktank.service.ISysDictService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.baomidou.dynamic.datasource.annotation.DS;
import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @Author zhangweijian
 * @since 2018-12-28
 */
@DS("slave")
@Service
public class SysDictItemServiceImpl extends ServiceImpl<SysDictItemMapper, SysDictItem> implements ISysDictItemService {

    @Autowired
    private SysDictItemMapper sysDictItemMapper;
    @Autowired
    private ISysDictService sysDictService;

    @Override
    public List<SysDictItem> selectByItemCode(String itemCode) {
        if (StringUtils.isEmpty(itemCode)) {
            return Lists.newArrayList();
        }
        List<SysDict> dictLst = sysDictService.list(Wrappers.lambdaQuery(SysDict.class).eq(SysDict::getDictCode, itemCode));
        if (CollectionUtils.isEmpty(dictLst)) {
            return Lists.newArrayList();
        }
        String dictId = dictLst.get(0).getId();
        return list(Wrappers.lambdaQuery(SysDictItem.class).eq(SysDictItem::getDictId, dictId));
    }
}
