#!/bin/sh

set -eu

. ./config.sh

echo "当前路径: ${PWD}"
echo "构建名称: ${name}"
echo "构建版本: ${version}"
echo "推送仓库: ${domain}/${namespace}"

docker build -f ./build/test/Dockerfile -t ${domain}/${namespace}/${name}:${version} .

echo "推送镜像"
docker login -u=$username -p=${passwd} ${domain}
docker push ${domain}/${namespace}/${name}:${version}

echo "清理none镜像"
docker image prune -af
