package com.zzsn.thinktank.vo;

import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 *
 *
 * @author lkg
 * @date 2024/8/23
 */
@Setter
@Getter
public class ThinkTankSourceVO {

    /**信息源组id*/
    private String groupId;
    //智库机构编码
    private String codeId;
    //中文全称
    private String chineseWhole;
    //关联信息源数量
    private Integer infoSourceCount;
    /**信息源id*/
    private String sourceId;
    //关联信息源编码
    private String infoSourceCode;
    //关联信息源名称
    private String webSiteName;
    //栏目名称
    private String siteName;
    //网址
    private String siteUri;
    //启用状态 1启用 0禁用
    private String status;
    /**信息源采集资讯数量**/
    private Integer infoCount;
    /**信息源进一个月的采集资讯数量**/
    private Integer infoMonthlyCount;
    /**智库下的资讯数量**/
    private Integer groupCount;

    public List<String> toList(){
        List<String> list = new ArrayList<>();
        list.add(getValue(groupId));
        list.add(getValue(codeId));
        list.add(getValue(chineseWhole));
        if (infoSourceCount == null) {
            list.add(" ");
        } else {
            list.add(String.valueOf(infoSourceCount));
        }
        if (groupCount == null) {
            list.add(" ");
        } else {
            list.add(String.valueOf(groupCount));
        }
        list.add(getValue(infoSourceCode));
        list.add(getValue(webSiteName));
        list.add(getValue(siteName));
        list.add(getValue(siteUri));
        list.add(getValue(status));
        if (infoCount == null) {
            list.add(" ");
        } else {
            list.add(String.valueOf(infoCount));
        }
        if (infoMonthlyCount == null) {
            list.add(" ");
        } else {
            list.add(String.valueOf(infoMonthlyCount));
        }
        return list;
    }

    private String getValue(String value){
        if (StringUtils.isEmpty(value)) {
            value = " ";
        }
        return value;
    }
}
