package com.zzsn.thinktank.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.thinktank.entity.ThinktankBasicInfo;
import com.zzsn.thinktank.vo.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/4/24 10:31
 * @Content:
 */
public interface ThinktankBasicInfoService extends IService<ThinktankBasicInfo> {

    Result<?> add(ThinktankBasicInfo thinktankBasicInfo);

    Result<?> del(String id);

    Result<?> edit(ThinktankBasicInfo thinktankBasicInfo);

    ThinktankBasicInfoVo getInfoById(String id);

    Result<?> getList(ThinktankBasicInfoListVo thinktankBasicInfoListVo);

    void downloadTemplate(HttpServletResponse response);

    Result batchImport(MultipartFile multipartFile);

    byte[] batchExport(ThinktankBasicInfoListVo thinktankBasicInfoListVo, HttpServletRequest request, HttpServletResponse response);

    Result<?> getListBaseData(String id, Integer pageNo, Integer pageSize, Integer office);

    /**
     * 批量导入智库信息
     *
     * @param thinkTankImportVOList 智库信息列表
     * @author lkg
     * @date 2024/8/23
     */
    String batchImport(List<ThinkTankFileVO> thinkTankImportVOList);

    /**
     * 根据搜索条件获取导出列表
     *
     * @param id            智库id集合,多个逗号隔开
     * @param codeId        主库编码
     * @param typeId        国家id
     * @param thinktankName 智库名称
     * @param tagId         研究领域id
     * @param keyword       关键词
     * @author lkg
     * @date 2024/8/23
     */
    List<ThinktankBasicInfo> exportListByCondition(String id, String codeId, String typeId,
                                                   String thinktankName, String tagId, String keyword);

    /**
     * 智库采集量统计
     *
     * @param dataList 智库列表
     * @author lkg
     * @date 2024/8/23
     */
    List<ThinkTankSourceVO> thinkTankCollectCount(List<ThinktankBasicInfo> dataList);
}
