package com.zzsn.thinktank.mapper;

import com.zzsn.thinktank.entity.ThinktankBasicInfo;
import com.zzsn.thinktank.entity.ThinktankOttInfo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.Date;
import java.util.List;

/**
 * @Description: 1
 * @Author: jeecg-boot
 * @Date:   2024-07-03
 * @Version: V1.0
 */
public interface ThinktankOttInfoMapper extends BaseMapper<ThinktankOttInfo> {

    /**
     * 根据智库机构编码获取ott信息
     * @param baseCode 智库机构编码
     * @return
     */
    @Select("select ott.id,ott.full_name fullName,ott.abbreviation,ott.summary,ott.contact,ott.areas,ott.organisation,ott.performance from thinktank_ott_info ott left join thinktank_base_ott_relation rel on ott.id = rel.ott_code where rel.base_code = #{baseCode}")
    ThinktankOttInfo getOttInfoByBaseCode(@Param("baseCode") String baseCode);

    /**
     * 获取智库收藏信息
     * @param baseCode 智库机构编码
     * @param userId 用户id
     * @return int 1-已收藏 0-未收藏
     */
    @Select("select count(1) from thinktank_collect where base_code = #{baseCode} and user_id = #{userId}")
    int getCollectInfo(@Param("baseCode") String baseCode,@Param("userId") String userId);

    /**
     * 获取已收藏的智库列表
     * @param userId
     * @return
     */
    @Select("select id,code_id codeId,chinese_whole chineseWhole,chinese_simple chineseSimple,english_whole englishWhole,english_simple englishSimple from thinktank_collect coll left join thinktank_basic_info tbi on coll.base_code = tbi.code_id where coll.user_id = #{userId} order by coll.create_time desc")
    List<ThinktankBasicInfo> getCollectList(@Param("userId") String userId);

    /**
     * 收藏智库
     * @param baseCode 智库机构编码
     * @param userId 用户id
     * @param date 收藏时间
     * @return
     */
    @Update("insert into thinktank_collect(base_code,user_id,create_time) value (#{baseCode},#{userId},#{date})")
    int collect(@Param("baseCode") String baseCode,@Param("userId") String userId, @Param("date") Date date);

    /**
     * 取消收藏智库
     * @param baseCode 智库机构编码
     * @param userId 用户id
     * @return
     */
    @Update("delete from thinktank_collect where base_code = #{baseCode} and user_id = #{userId}")
    int cancelCollect(@Param("baseCode") String baseCode,@Param("userId") String userId);

    /**
     * 智库关联ott
     * @param baseCode 智库表智库编码
     * @param ottCode ott表主键
     */
    @Insert("insert into thinktank_base_ott_relation(base_code,ott_code) values (#{baseCode},#{ottCode})")
    void addRelation(String baseCode, String ottCode);

    /**
     * 根据智库编码查询已关联ott
     * @param baseCode 智库编码
     * @return
     */
    @Select("select ott_code from thinktank_base_ott_relation where base_code = #{baseCode}")
    String getRelation(String baseCode);

    /**
     * 更新智库已关联的ott
     * @param baseCode 智库编码
     * @param ottCode ott表主键
     */
    @Update("update thinktank_base_ott_relation set ott_code = #{ottCode} where base_code = #{baseCode}")
    void updateRelation(String baseCode, String ottCode);

}
