package com.zzsn.thinktank.controller;

import com.zzsn.thinktank.service.CityAddressService;
import com.zzsn.thinktank.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/9 15:54
 * @Content: 地市信息查询
 */
@RestController
@RequestMapping("/api/cityAddress")
public class CityAddressController {

    @Autowired
    CityAddressService cityAddressService;

    @GetMapping("/getCityList")
    public Result<?> getCityList(){
        return cityAddressService.getCityList();
    }

    /**
     * 根据父pid查询所有子节点
     * 要查询根节点下的子节点pid传 "0"
     * 默认值为0
     * @param pid
     * @return
     */
    @GetMapping("/getCityListByPid")
    public Result<?> getCityListByPid(@RequestParam(name="pid",required=true) String pid){
        //
        if(pid == null || pid.length() == 0){
            pid = "0";
        }
        return cityAddressService.getCityListByPid(pid);
    }
}
