#!/bin/sh

set -eu

# 1.0.0_$(date +'%Y%m%dT%H%M%S')
# version="T1.0.0-$(date +'%Y%m%d-%H%M%S')"
version="latest"
domain="${repo_domain}"
namespace="${repo_namespace}"
username="${repo_username}"
passwd="${repo_passwd}"
dir="/zzsn/think-tank/test"
name="think-tank-test"
echo "构建名称: ${name}"
echo "构建版本: ${version}"
echo "推送仓库: ${domain}/${namespace}"

docker build -f ./Dockerfile -t ${domain}/${namespace}/${name}:${version} ../..

echo "推送镜像"
docker login -u=$username -p=${passwd} ${domain}
docker push ${domain}/${namespace}/${name}:${version}

#echo "运行程序"
#
#if [ "$(docker ps -aqf "name=^${name}")" ]; then
#    # 如果存在，则停止并删除容器
#    echo "停止并删除容器: ${name}"
#    docker rm -f "${name}"
#else
#    echo "容器不存在直接运行: ${name}"
#fi
#
## 运行测试环境
#docker run --restart always -d -p 9099:9099 --name ${name} \
#-v /etc/localtime:/etc/localtime:ro \
#${domain}/${namespace}/${name}:${version}

echo "清理none镜像"
docker image prune -af
