#!/bin/sh

set -eu

version="latest"
domain="registry.cn-beijing.aliyuncs.com"
namespace="yotop"
dir="/zzsn/think-tank/test"
name="think-tank-test"

echo "运行容器"

if [ "$(docker ps -aqf "name=^${name}")" ]; then
    # 如果存在，则停止并删除容器
    echo "停止并删除容器: ${name}"
    docker rm -f "${name}"
else
    echo "容器不存在直接运行: ${name}"
fi

# 运行测试环境
docker run --restart always -d -p 9099:9099 --name ${name} \
-v /etc/localtime:/etc/localtime:ro \
-v ${dir}/logs:/clbLogs/thinktank \
${domain}/${namespace}/${name}:${version}