#!/bin/sh

set -eu

version="latest"
domain="registry.cn-beijing.aliyuncs.com"
namespace="yotop"
username="${repo_username}"
passwd="${repo_passwd}"
dir="/zzsn/think-tank/test"
name="think-tank-test"

echo "当前路径: ${PWD}"
echo "构建名称: ${name}"
echo "构建版本: ${version}"
echo "推送仓库: ${domain}/${namespace}"

echo "构建镜像"
docker build -f ./build/test/Dockerfile -t ${domain}/${namespace}/${name}:${version} .

echo "推送镜像"
docker login -u=$username -p=${passwd} ${domain}
docker push ${domain}/${namespace}/${name}:${version}

echo "清理none镜像"
docker image prune -af
