package com.zzsn.thinktank.config.threadPool;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.ThreadPoolExecutor;

@Configuration
public class ExecutorConfig {

    @Bean
    public ThreadPoolTaskExecutor threadPoolTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(20);           // Set core pool size
        executor.setMaxPoolSize(50);          // Set maximum pool size
        executor.setQueueCapacity(100);        // Set queue capacity
        executor.setKeepAliveSeconds(60);     // Set keep-alive time
        executor.setThreadNamePrefix("year-report-dataHandler-"); // Set thread name prefix
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy()); // Set rejection policy
        return executor;
    }
}
