package com.zzsn.thinktank.controller;

import com.zzsn.thinktank.service.EnterpriseService;
import com.zzsn.thinktank.vo.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/4/26 14:16
 * @Content:
 */
@Slf4j
@RestController
@RequestMapping("/api/enterprise")
public class EnterpriseController {

    @Autowired
    EnterpriseService enterpriseService;

    /**
     * 企业查询
     * @param pageNo
     * @param pageSize
     * @param socialCreditCode
     * @param name
     * @return
     */
    @GetMapping("/pageList")
    public Result<?> pageList(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                              @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                              @RequestParam(name="socialCreditCode", required=false) String socialCreditCode,
                              @RequestParam(name="name", required=false) String name) {
        return enterpriseService.pageList(pageNo, pageSize,socialCreditCode,name);
    }

}
