package com.zzsn.thinktank.controller;

import com.zzsn.thinktank.entity.ThinktankBasicInfo;
import com.zzsn.thinktank.service.ThinktankBasicInfoService;
import com.zzsn.thinktank.vo.Result;
import com.zzsn.thinktank.vo.ThinktankBasicInfoListVo;
import com.zzsn.thinktank.vo.ThinktankBasicInfoVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Map;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/4/24 10:28
 * @Content:
 */
@Slf4j
@RestController
@RequestMapping("/api/basicinfo")
public class ThinktankBasicInfoController {

    @Autowired
    ThinktankBasicInfoService thinktankBasicInfoService;


    /**
     * 新增
     * @param thinktankBasicInfo
     * @return
     */
    @PostMapping("/add")
    public Result<?> add(@RequestBody ThinktankBasicInfo thinktankBasicInfo){
        log.info("新增信息：{}",thinktankBasicInfo);
        return thinktankBasicInfoService.add(thinktankBasicInfo);
    }

    /**
     * 根据id主键删除
     * @param id
     * @return
     */
    @GetMapping("/del")
    public Result<?> del(@RequestParam(name="id",required=true) String id){
        log.info("根据id删除:{}", id);
        return thinktankBasicInfoService.del(id);
    }

    /**
     * 根据id修改信息
     * @param thinktankBasicInfo
     * @return
     */
    @PostMapping("/edit")
    public Result<?> edit(@RequestBody ThinktankBasicInfo thinktankBasicInfo){
        log.info("根据id修改信息:{}",thinktankBasicInfo);
        if(thinktankBasicInfo.getId() == null)
            return Result.error(400, "id不能为空");
        return thinktankBasicInfoService.edit(thinktankBasicInfo);
    }

    /**
     * 根据id主键查询
     * @param id
     * @return
     */
    @GetMapping("getById")
    public Result<?> getById(@RequestParam(name="id",required=true) String id){
        log.info("根据id主键查询:{}",id);
        ThinktankBasicInfoVo thinktankBasicInfo = thinktankBasicInfoService.getInfoById(id);
        return Result.OK(thinktankBasicInfo);
    }

    @PostMapping("/list")
    public Result<?> getList(@RequestBody ThinktankBasicInfoListVo thinktankBasicInfoListVo){
        log.info("智库信息条件分页查询:{}", thinktankBasicInfoListVo);
        Integer pageNo = thinktankBasicInfoListVo.getPageNo();
        Integer pageSize= thinktankBasicInfoListVo.getPageSize();
        if(pageNo < 1)
            pageNo = 1;
        if(pageSize < 0)
            pageSize = 10;
        Integer office = pageSize * (pageNo - 1);
        thinktankBasicInfoListVo.setOffset(office);
        return thinktankBasicInfoService.getList(thinktankBasicInfoListVo);
    }

    /**
     * 模板下载
     * @param response
     */
    @GetMapping("/downloadTemplate")
    public void downloadTemplate(HttpServletResponse response) {
        thinktankBasicInfoService.downloadTemplate(response);
    }

    /**
     * 批量导入数据
     * @param
     * @return
     */
    @Transactional
    @PostMapping("/batchImport")
    public Result<?> batchImport( HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        if (fileMap.size() < 1) {
            return Result.error("请上传文件!");
        }
        MultipartFile multipartFile = fileMap.get(new ArrayList<>(fileMap.keySet()).get(0));
        Result result = thinktankBasicInfoService.batchImport(multipartFile);
        return  result;

    }

    @PostMapping("/batchExport")
    public byte[] batchExport(@RequestBody ThinktankBasicInfoListVo thinktankBasicInfoListVo,HttpServletRequest request, HttpServletResponse response){
        log.info("导出:{}", thinktankBasicInfoListVo);
//        Integer pageNo = thinktankBasicInfoListVo.getPageNo();
//        Integer pageSize= thinktankBasicInfoListVo.getPageSize();
//        if(pageNo < 1)
//            pageNo = 1;
//        if(pageSize < 0)
//            pageSize = 10;
//        Integer office = pageSize * (pageNo - 1);
//        thinktankBasicInfoListVo.setOffset(office);
        return thinktankBasicInfoService.batchExport(thinktankBasicInfoListVo,request,response);
    }



}
