package com.zzsn.thinktank.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.thinktank.entity.ThinktankBasicInfo;
import com.zzsn.thinktank.vo.ThinktankBasicInfoExportVo;
import com.zzsn.thinktank.vo.ThinktankBasicInfoListVo;
import com.zzsn.thinktank.vo.ThinktankBasicInfoVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/4/24 10:34
 * @Content:
 */
@Mapper
public interface ThinktankBasicInfoMapper extends BaseMapper<ThinktankBasicInfo> {
    List<ThinktankBasicInfoVo> getList(ThinktankBasicInfoListVo thinktankBasicInfoListVo);

    Integer getCount(ThinktankBasicInfoListVo thinktankBasicInfoListVo);

    List<ThinktankBasicInfoExportVo> getExportList(ThinktankBasicInfoListVo thinktankBasicInfoListVo);

    /**
     * 根据搜索条件获取导出列表
     *
     * @param ids           智库id集合
     * @param codeId        主库编码
     * @param typeId        国家id
     * @param thinktankName 智库名称
     * @param tagId         研究领域id
     * @param keyword       关键词
     * @author lkg
     * @date 2024/8/23
     */
    List<ThinktankBasicInfo> exportListByCondition(@Param("ids") List<String> ids, @Param("codeId") String codeId, @Param("typeId") String typeId,
                                                   @Param("thinktankName") String thinktankName, @Param("tagId") String tagId, @Param("keyword") String keyword);
}
