package com.zzsn.thinktank.util;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Es对日期类型处理
 * @author kongliufeng
 * @create 2020-08-07 14:05
 */
public class EsDateUtil {

    static SimpleDateFormat format;

    /**
     * yyyy-MM-dd HH:mm:ss ->yyyy-MM-ddTHH:mm:ss
     * @param data
     * @return
     */
    public static String esFieldDateFormat(String data) {
        if (data == null)
            return data;
        if (data.length() == 19) {//标准yyyy-MM-dd HH:mm:ss
            return data.replace(" ", "T");
        } else if (data.length() == 10) {//yyyy-MM-dd
            return data;
        }
        return null;
    }

    /**
     * yyyy-MM-dd HH:mm:ss ->yyyy-MM-ddTHH:mm:ss
     * @param data
     * @return
     */
    public static String esFieldDateMapping(String data) {
        if (data == null)
            return data;
        if (data.length() == 19) {//标准yyyy-MM-dd HH:mm:ss
            return data.replace("T", " ");
        } else if (data.length() == 10) {//yyyy-MM-dd
            return data;
        }
        return null;
    }

    public static String dateToString(Date date) {
        format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }
}
