package com.zzsn.thinktank.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;

/**
 * @Description: 信息源表
 * @Author: jeecg-boot
 * @Date:   2022-01-18
 * @Version: V1.0
 */
@Data
@TableName("info_source")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class InfoSource implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    private String id;
	/**信息源编码*/
    private String infoSourceCode;
	/**信息源名称*/
    private String webSiteName;
	/**栏目名称*/
    private String siteName;
	/**栏目地址*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String siteUri;
    /**微博认证方式(1:个人微博 2:官方微博)*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String authMode;
    /**功能介绍，微博认证描述*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String remarks;
    /**公众号BIZ*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String biz;
    /**是否大V*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private int ynBigV;
	/**网站重要级别*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String siteLevel;
	/**国家*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String country;
	/**地区*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String area;
	/**语种*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String language;
	/**境外、公共、翻墙*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String checkedList;
	/**历史数据URL*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String hisUriExp;
	/**历史数据开始时间*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private java.util.Date hisDateStartTime;
	/**历史数据结束时间*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private java.util.Date hisDateEndTime;
	/**是否历史所有数据*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String ynHisDataAll;
	/**状态*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String status;
	/**列表页URL*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String listUrl;
	/**表达式类型*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String listExpressionType;
	/**匹配资讯的url*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String informationUrl;
	/**匹配资讯标题*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String informationTitle;
	/**匹配资讯发布时间*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String informationPublishDate;
	/**匹配资讯来源*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String informationSource;
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String infoBlockPosition;
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String linkLocation;
	/**自定义实体*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Object extractInfo;
	/**爬取深度*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer crawlDepth;
	/**页码url*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String pageUrl;
    /**匹配页码*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String matchPage;
	/**开始页码*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer pageStart;
	/**结束页码*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer pageEnd;
	/**是否所有页*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String ynPageAll;
	/**表达式类型*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String detailExpressionType;
	/**详情页表URL*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String detailUrl;
	/**匹配详情页标题*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String detailExpressionTitle;
	/**匹配详情页时间*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String detailExpressionPublishDate;
	/**匹配详情页来源*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String detailExpressionSource;
	/**匹配详情页作者*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String detailExpressionAuthor;
	/**匹配详情页摘要*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String detailExpressionSummary;
	/**匹配详情页正文*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String detailExpressionContent;
	/**自定义实体*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Object detailInfo;
	/**是否下载附件*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String ynDownload;
	/**数据表格页URL*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String formUrl;
	/**数据表格标题*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String formTitle;
	/**表达式类型*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer formType;
	/**数据表格表达式*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String dataFormExpression;
	/**自定义*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Object dataFormInfo;
	/**页码URL*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String dataPageUrl;
	/**页码规则*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String dataPageRule;
	/**开始页码*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer dataPageStart;
	/**结束页码*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer dataPageEnd;
	/**是否所有页码*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String ynDataPageAll;
	/**数据类型*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer dataType;
	/**数据格式*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer dataFormat;
	/**数据存储方式*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer dataStorageMode;
	/**数据存储信息*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Object dataStorageInfo;
	/**是否动态爬取*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer ynDynamicCrawl;
	/**是否需要登陆*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer ynLogin;
	/**登陆域名*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String domainName;
	/**登陆链接*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String link;
	/**登陆账号*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String account;
	/**登陆密码*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String password;
	/**userAgent*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String userAgent;
	/**referer*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String referer;
	/**cookies*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String cookies;
	/**headers*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String headers;
	/**其它参数*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String otherInfo;
	/**爬虫类别*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer crawlType;
	/**爬虫名称*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String crawlName;
	/**爬虫地址*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String crawlAddress;
	/**参数*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Object parameter;
    /**设置方式(1:自由设置 2:cron表达式)*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer setMode;
    /**定时方式(1:时间间隔 2:立即执行)*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String timerMode;
    /**定时单位(1分；2小时；3日；4月)*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String unit;
    /**定时数值*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer space;
	/**cron表达式*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String cron;
	/**说明*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String explaination;
	/**创建人*/
    private String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private java.util.Date createTime;
	/**更新人*/
    private String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private java.util.Date updateTime;
	/**所属部门*/
    private String sysOrgCode;
    /**验证结果*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String verification;
    /**所属单位*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String company;
    /**所属行业*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String industry;
    /**权威性*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String authority;
    /**可信度*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String reliability;
    /**原创度*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String originality;
    /**父网站*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String parentSite;
    /**是否保存快照（1：保存   0：不保存）*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String ynSnapshot;

}
