package com.zzsn.thinktank.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang3.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
@TableName("thinktank_basic_info")
public class ThinktankBasicInfo extends Model<ThinktankBasicInfo> {

  //主键
  @TableId(value = "id", type = IdType.ASSIGN_ID)
  private String id;
  //智库机构编码
  private String codeId;
  //中文全称
  private String chineseWhole;
  //中文简称
  private String chineseSimple;
  //英文全称
  private String englishWhole;
  //英文简称
  private String englishSimple;
  //原文全称
  private String originalWhole;
  //原文简称
  private String originalSimple;
  //官网
  private String officialWebsite;
  //标签id 多个标签使用逗号分隔
  private String tagId;
  //标签名称 多个标签使用逗号分隔
  private String tagName;
  //成立时间
  private String establishTime;
  //是否收费  1是 0否  默认为空值
  private Integer charge;
  //国内外
  private String countryWithinExternal;
  //所属国家/地区 ID
  private String belongCountryId;
  //所属国家/地区
  private String belongCountry;
  //所在地区
  private String region;
  //地址
  private String address;
  //创办单位/所属单位 企业信用代码
  private String belongUnitCode;
  //创办单位/所属单位
  private String belongUnit;
  //机构头像
  private String headSculpture;
  //简介
  private String biographicalNotes;
  //属性 区分智库机构、咨询公司、新闻媒体
  private String attribute;
  //启停状态  1启 0停
  private Integer status;
  //创建人
  private String createBy;
  //创建时间
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  //更新人
  private String updateBy;
  //更新时间
  @TableField(fill = FieldFill.UPDATE)
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date updateTime;

  //语言
  private String lang;
  //运营状态
  private String operateStatus;
  //营利性质
  private String profitNature;
  //智库性质
  private String nature;
  //影响力和地位
  private String influencePosition;
  //人员规模
  private String staffSize;
  //智库规模
  private String scale;
  //成果类型
  private String achievementType;
  //资金来源
  private String fundsSource;

  public List<String> toList(){
    List<String> list = new ArrayList<>();
    list.add(getValue(id));
    list.add(getValue(codeId));
    list.add(getValue(chineseWhole));
    list.add(getValue(chineseSimple));
    list.add(getValue(englishWhole));
    list.add(getValue(englishSimple));
    list.add(getValue(officialWebsite));
    list.add(getValue(belongCountry));
    list.add(getValue(lang));
    list.add(getValue(operateStatus));
    list.add(getValue(profitNature));
    list.add(getValue(nature));
    list.add(getValue(tagName));
    list.add(getValue(influencePosition));
    list.add(getValue(staffSize));
    list.add(getValue(scale));
    list.add(getValue(achievementType));
    list.add(getValue(fundsSource));
    list.add(getValue(originalWhole));
    list.add(getValue(originalSimple));
    list.add(getValue(biographicalNotes));
    list.add(getValue(establishTime));
    if (charge != null) {
      list.add(String.valueOf(charge));
    } else {
      list.add("");
    }
    list.add(getValue(address));
    list.add(getValue(belongUnit));
    return list;
  }

  private String getValue(String value){
    if (StringUtils.isEmpty(value)) {
      value = "";
    }
    return value;
  }

}
