package com.zzsn.leaderbase.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.vo.BasicInfoListVo;
import com.zzsn.leaderbase.vo.CharacterVo;
import com.zzsn.leaderbase.vo.CheckVo;
import com.zzsn.leaderbase.vo.Result;
import org.springframework.http.ResponseEntity;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/29 10:35
 * @Content:
 */
public interface CharacterBasicInfoService extends IService<CharacterBasicInfo> {

    CharacterVo getByUid(String uid);

    CharacterBasicInfo getOneById(String id);

    IPage<CharacterBasicInfo> getList(BasicInfoListVo basicInfoListVo);

    List<CharacterVo> checkList(String articleId,String checkResult);

    List<CharacterBasicInfo> getListByName(String name);

    Integer deduplication(String duty, String company, String name);

    List<CharacterBasicInfo> getData(String time);

    List<CharacterBasicInfo> getPreviousDuty(String uid,String id,String category);

    List<String> getCorrelationByUid(String uid);

    List<CharacterVo> getByOriginalId(String id);

    Result<?> add(CharacterBasicInfo characterBasicInfo);

    Result<?> edit(CharacterBasicInfo characterBasicInfo);

    Boolean del(String id);

    Result<?> correlation(CharacterBasicInfo characterBasicInfo);

    Result<?> correlationEdit(CharacterBasicInfo characterBasicInfo);

    Result<?> correlationMerge(CheckVo checkVo);

    String getDepartmentCreditCode(String socialCreditCode);

    List<CharacterBasicInfo> getBasicInfoByCreditCode(String socialCreditCode);

    List<Map<String, String>> getDepartment(String socialCreditCode, String department, String keyword);

    List<CharacterBasicInfo> getAllList(BasicInfoListVo basicInfoListVo);

    CharacterBasicInfo getBasicInfoByUid(String category,String uid);

    CharacterBasicInfo getByNameAndByDepartment(String category, String typeId, String name, String department);

    String importExcel(String absolutePath, String category, Map<String, String> importFieldMap);

    ResponseEntity<byte[]> exportExcel(String category, List<CharacterBasicInfo> list, Map<String, String> importFieldMap) throws IOException;

    ResponseEntity<byte[]> exportExcelByIds(String category, String ids, Map<String, String> importFieldMap) throws IOException;

    ResponseEntity<byte[]> exportTemplate(Map<String, String> importFieldMap) throws IOException;

    List<CharacterBasicInfo> getDutyList(String uid, String socialCreditCode, String name);
}
