package com.zzsn.leaderbase.util;

import cn.hutool.core.net.URLDecoder;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;

/**
 * @Description: 并发调用限制工具
 * @Author: jeecg-boot
 * @Date:   2024-01-04
 * @Version: V1.0
 */
@Data
public class AuthUtil {
	public final static String LOGIN_USER_HEADER = "loginUser";
	
	static SimpleDateFormat format;
	
	public static LoginUser getLoginUser() {
		try {
			HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
			String userInfo = URLDecoder.decode(request.getHeader(LOGIN_USER_HEADER), StandardCharsets.UTF_8);
			return JSON.parseObject(userInfo, LoginUser.class);
		}catch (Exception e){
			return null;
		}
	}
	/**
	 * 检查是否可以访问
	 * @param code 服务编码
	 * @return null：无有效记录，true：可以访问，false：不能访问
	 */
	public static Boolean checkVisit(String code, HttpServletRequest request){
		return null;
	}


}
