package com.zzsn.leaderbase.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.entity.CharacterExtractInfo;
import com.zzsn.leaderbase.mapper.CharacterExtractInfoMapper;
import com.zzsn.leaderbase.service.CharacterBasicInfoService;
import com.zzsn.leaderbase.service.CharacterExtractInfoService;
import com.zzsn.leaderbase.service.IGeneratorIdService;
import com.zzsn.leaderbase.vo.CheckVo;
import com.zzsn.leaderbase.vo.ExtractListVo;
import com.zzsn.leaderbase.vo.Result;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

@Service
public class CharacterExtractInfoServiceImpl extends ServiceImpl<CharacterExtractInfoMapper, CharacterExtractInfo> implements CharacterExtractInfoService {

    //生成id
    @Autowired
    IGeneratorIdService generatorIdService;
    @Autowired
    CharacterBasicInfoService characterBasicInfoService;

    /**
     * 数据重复返回true  数据不重复，返回false
     * @param curStation
     * @param department
     * @param person
     * @return
     */
    @Override
    public boolean deduplication(String curStation, String department, String person) {
        Integer count = baseMapper.deduplication(curStation, department, person);
        if(count == 0){ return false; }
        else { return true; }
    }

    @Override
    public Result<?> addBulk(List<CharacterExtractInfo> list) {
        this.saveBatch(list);
        return Result.OK();
    }

    @Override
    public Result<?> getList(ExtractListVo extractListVo) {
        List<CharacterExtractInfo> list = baseMapper.getList(extractListVo);
        Integer total = baseMapper.getListCount(extractListVo);

        IPage page = new Page();
        page.setRecords(list);
        page.setTotal(total);
        Integer pageNo = extractListVo.getPageNo();
        Integer pageSize= extractListVo.getPageSize();
        page.setCurrent(pageNo);
        page.setSize(pageSize);
        return Result.OK(page);
    }

    @Override
    public Result<?> del(String id) {
        List<String> ids = Arrays.asList(id.split(","));
        return Result.OK(this.removeByIds(ids));
    }

    @Override
    public Result<?> checkNewlyAdded(CheckVo checkVo) {
        //查询审核人物信息
        String extractId = checkVo.getExtractId();
        CharacterExtractInfo extractInfo = this.getById(extractId);

        //保存人物信息
        CharacterBasicInfo character = checkVo.getCharacter();
        String id = Long.toString(generatorIdService.getOrderId());
        character.setId(id);
        character.setCreateTime(new Date());
        String uid = generatorIdService.getIdNo();
        character.setUid(uid);
        character.setCategory("1");//审核人物默认入领导人
        character.setMainEntry(1);
        character.setArticleId(extractInfo.getArticleId());
        character.setArticleIndex(extractInfo.getArticleIndex());
        character.setArticleTitle(extractInfo.getArticleTitle());
        character.setArticleOrigin(extractInfo.getArticleOrigin());
        character.setUpdateDesc(extractInfo.getUpdateDesc());
        Boolean characterRes = characterBasicInfoService.save(character);
        if(!characterRes)
            return Result.error("人物信息保存失败");

        //修改审核状态
        UpdateWrapper<CharacterExtractInfo> extractWrapper = new UpdateWrapper<>();
        extractWrapper.eq("id", extractId)
                .set("check_status", 1);
        Boolean updateCheck = this.update(extractWrapper);
        if(!updateCheck)
            return Result.error("审核状态更改失败！");

        return Result.OK();
    }

    @Override
    public Result<?> checkMerge(CheckVo checkVo) {
        //查询审核人物信息
        String extractId = checkVo.getExtractId();
        CharacterExtractInfo extractInfo = this.getById(extractId);
        //查询疑似人物信息
        String suspectedId = checkVo.getSuspectedId();
        CharacterBasicInfo suspectedInfo = characterBasicInfoService.getById(suspectedId);

        //保存人物信息
        CharacterBasicInfo character = checkVo.getCharacter();
        String id = Long.toString(generatorIdService.getOrderId());
        character.setId(id);
        character.setCreateTime(new Date());
        String uid = suspectedInfo.getUid();
        character.setUid(uid);
        character.setCategory("1");//审核人物默认入领导人
        character.setMainEntry(1);
        character.setArticleId(extractInfo.getArticleId());
        character.setArticleIndex(extractInfo.getArticleIndex());
        character.setArticleTitle(extractInfo.getArticleTitle());
        character.setArticleOrigin(extractInfo.getArticleOrigin());
        character.setUpdateDesc(extractInfo.getUpdateDesc());
        Boolean characterRes = characterBasicInfoService.save(character);
        if(!characterRes)
            return Result.error("人物信息保存失败");

        //修改审核状态
        UpdateWrapper<CharacterExtractInfo> extractWrapper = new UpdateWrapper<>();
        extractWrapper.eq("id", extractId)
                .set("check_status", 1);
        Boolean updateCheck = this.update(extractWrapper);
        if(!updateCheck)
            return Result.error("审核状态更改失败！");

        //人物信息为现任，则将该人物的原现任信息修改为历任
        if("在职".equals(character.getTakeOfficeStatus())){
            UpdateWrapper<CharacterBasicInfo> suspectedWrapper = new UpdateWrapper<>();
            suspectedWrapper.eq("id", suspectedId)
                    .set("take_office_status", "历任")
                    .set("main_entry",0);
            Boolean updateTask = characterBasicInfoService.update(suspectedWrapper);
            if(!updateTask)
                return Result.error("疑似人物任职状态更改失败！");
        }

        //批量修改同一人物的基本信息
        UpdateWrapper<CharacterBasicInfo> uidWrapper = new UpdateWrapper<>();
        uidWrapper.eq("uid", uid);
        if(StringUtils.isNotEmpty(character.getName()))
            uidWrapper.set("name", character.getName());
        if(StringUtils.isNotEmpty(character.getSex()))
            uidWrapper.set("sex", character.getSex());
        if(StringUtils.isNotEmpty(character.getBirthplace()))
            uidWrapper.set("birthplace", character.getBirthplace());
        if(StringUtils.isNotEmpty(character.getBirthday()))
            uidWrapper.set("birthday", character.getBirthday());
        if(StringUtils.isNotEmpty(character.getNativePlace()))
            uidWrapper.set("native_place", character.getNativePlace());
        if(StringUtils.isNotEmpty(character.getSchool()))
            uidWrapper.set("school", character.getSchool());
        if(StringUtils.isNotEmpty(character.getSpeciality()))
            uidWrapper.set("speciality", character.getSpeciality());
        if(StringUtils.isNotEmpty(character.getEducation()))
            uidWrapper.set("education", character.getEducation());
        if(StringUtils.isNotEmpty(character.getExpertOccupation()))
            uidWrapper.set("expert_occupation", character.getExpertOccupation());
        if(StringUtils.isNotEmpty(character.getHeadSculpture()))
            uidWrapper.set("head_sculpture", character.getHeadSculpture());
        if(StringUtils.isNotEmpty(character.getBiographicalNotes()))
            uidWrapper.set("biographical_notes", character.getBiographicalNotes());

        Boolean updateUid = characterBasicInfoService.update(uidWrapper);
        if(!updateUid)
            return Result.error("人物基本信息修改失败！");

        return Result.OK();
    }
}
