package com.zzsn.leaderbase.util;

import cn.hutool.core.bean.BeanUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

@Slf4j
public class BeanUtils {

    /**
     * 合并两个类中的属性，有冲突以后面类中传参为准
     * @param target
     * @param destination
     * @return
     * @param <M>
     */
    public static <M> M merge(M target, M destination){
        try {
            Map<String, Object> map = BeanUtil.beanToMap(target);
            map.putAll(BeanUtil.beanToMap(destination,false,true));
            return (M) BeanUtil.mapToBean(map, target.getClass(), false);
        } catch (Exception e) {
            log.error("合并对象异常：{}", e.getMessage(), e);
            return target;
        }
    }
}
